/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.util;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NameTemplate
implements Cloneable {
    public transient Placeholder[] allowed;
    public String template;
    public static final Placeholder TABLE = new Placeholder("{table}", "table name", "table1");
    public static final Placeholder COLUMNS = new Placeholder("{columns}", "columns names", "col1_col2");
    public static final Placeholder REF_TABLE = new Placeholder("{ref_table}", "referenced table name", "rtable2");
    public static final Placeholder REF_COLUMNS = new Placeholder("{ref_columns}", "referenced columns names", "rcol1_rcol2");
    public static final Placeholder UNIQUE = new RegexPlaceholder("{unique?*:*}", "\\{unique\\?([^:}]*):([^:}]*)\\}", "uniqueness infix", "$1");

    public NameTemplate(@NotNull String template, Placeholder ... allowed) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/util/NameTemplate", "<init>"));
        }
        if (allowed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowed", "com/intellij/sql/util/NameTemplate", "<init>"));
        }
        this.allowed = allowed;
        this.template = template;
    }

    @NotNull
    public static String example(@NotNull String template, Placeholder ... allowed) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/util/NameTemplate", "example"));
        }
        if (allowed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowed", "com/intellij/sql/util/NameTemplate", "example"));
        }
        SubstitutionBuilder builder = new SubstitutionBuilder(template);
        for (Placeholder placeholder : allowed) {
            builder.substitute(placeholder, placeholder.example);
        }
        String string = builder.build();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate", "example"));
        }
        return string;
    }

    @NotNull
    public abstract String getName(@NotNull DasObject var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameTemplate template1 = (NameTemplate)o;
        if (!Arrays.equals(this.allowed, template1.allowed)) {
            return false;
        }
        return this.template.equals(template1.template);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.allowed);
        result = 31 * result + this.template.hashCode();
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        NameTemplate clone = (NameTemplate)super.clone();
        clone.allowed = this.allowed;
        clone.template = this.template;
        return clone;
    }

    public static class PrimaryKeyNameTemplate
    extends NameTemplate {
        public static final String DEFAULT = "{table}_{columns}_pk";

        public PrimaryKeyNameTemplate() {
            this(DEFAULT);
        }

        public PrimaryKeyNameTemplate(@NotNull String template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "<init>"));
            }
            super(template, TABLE, COLUMNS);
        }

        public PrimaryKeyNameTemplate(@NotNull SqlCodeStyleSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "<init>"));
            }
            this(settings.PRIMARY_KEY_NAME_TEMPLATE);
        }

        @NotNull
        public String getName(@NotNull String tableName, @NotNull Iterable<String> columnNames) {
            if (tableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableName", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "getName"));
            }
            if (columnNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "getName"));
            }
            String string = new SubstitutionBuilder(this.template).substitute(TABLE, tableName).substitute(COLUMNS, StringUtil.join(columnNames, (String)"_")).build();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "getName"));
            }
            return string;
        }

        @NotNull
        public String getName(@NotNull DasTable table, @NotNull Iterable<? extends DasTypedObject> columns) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "getName"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "getName"));
            }
            String string = this.getName(table.getName(), (Iterable<String>)JBIterable.from(columns).transform(DasUtil.TO_NAME));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName(@NotNull DasObject object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "getName"));
            }
            DasTableKey key = (DasTableKey)ObjectUtils.tryCast((Object)object, DasTableKey.class);
            String string = key == null ? object.getName() : this.getName(key.getTable(), key.getColumnsRef().resolveObjects());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate", "getName"));
            }
            return string;
        }
    }

    public static class IndexNameTemplate
    extends NameTemplate {
        public static final String DEFAULT = "{table}_{columns}_{unique?u:}index";

        public IndexNameTemplate() {
            this(DEFAULT);
        }

        public IndexNameTemplate(@NotNull String template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "<init>"));
            }
            super(template, TABLE, COLUMNS, UNIQUE);
        }

        public IndexNameTemplate(@NotNull SqlCodeStyleSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "<init>"));
            }
            this(settings.INDEX_NAME_TEMPLATE);
        }

        @NotNull
        public String getName(@NotNull String tableName, @NotNull Iterable<String> columnNames, boolean unique) {
            if (tableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableName", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "getName"));
            }
            if (columnNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "getName"));
            }
            String string = new SubstitutionBuilder(this.template).substitute(TABLE, tableName).substitute(COLUMNS, StringUtil.join(columnNames, (String)"_")).substitute(UNIQUE, unique ? "$1" : "$2").build();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "getName"));
            }
            return string;
        }

        @NotNull
        public String getName(@NotNull DasTable table, @NotNull Iterable<? extends DasTypedObject> columns, boolean unique) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "getName"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "getName"));
            }
            String string = this.getName(table.getName(), (Iterable<String>)JBIterable.from(columns).transform(DasUtil.TO_NAME), unique);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName(@NotNull DasObject object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "getName"));
            }
            DasIndex index = (DasIndex)ObjectUtils.tryCast((Object)object, DasIndex.class);
            String string = index == null ? object.getName() : this.getName(index.getTable(), index.getColumnsRef().resolveObjects(), index.isUnique());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$IndexNameTemplate", "getName"));
            }
            return string;
        }
    }

    public static class ForeignKeyNameTemplate
    extends NameTemplate {
        public static final String DEFAULT = "{table}_{ref_table}_{ref_columns}_fk";

        public ForeignKeyNameTemplate() {
            this(DEFAULT);
        }

        public ForeignKeyNameTemplate(@NotNull String template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "<init>"));
            }
            super(template, TABLE, COLUMNS, REF_TABLE, REF_COLUMNS);
        }

        public ForeignKeyNameTemplate(@NotNull SqlCodeStyleSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "<init>"));
            }
            this(settings.FOREIGN_KEY_NAME_TEMPLATE);
        }

        @NotNull
        public String getName(@NotNull String tableName, @NotNull Iterable<String> columnNames, @NotNull String targetName, @NotNull Iterable<String> targetColumnNames) {
            if (tableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableName", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            if (columnNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            if (targetName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetName", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            if (targetColumnNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetColumnNames", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            String string = new SubstitutionBuilder(this.template).substitute(TABLE, tableName).substitute(COLUMNS, StringUtil.join(columnNames, (String)"_")).substitute(REF_TABLE, targetName).substitute(REF_COLUMNS, StringUtil.join(targetColumnNames, (String)"_")).build();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            return string;
        }

        @NotNull
        public String getName(@NotNull DasTable table, @NotNull Iterable<? extends DasTypedObject> columns, @Nullable DasTable target, @NotNull Iterable<? extends DasTypedObject> targetColumns) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            if (targetColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetColumns", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            String string = this.getName(table.getName(), (Iterable<String>)JBIterable.from(columns).transform(DasUtil.TO_NAME), target == null ? "" : target.getName(), (Iterable<String>)JBIterable.from(targetColumns).transform(DasUtil.TO_NAME));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            return string;
        }

        @NotNull
        public String getName(@NotNull DasTable table, @NotNull Iterable<? extends DasTypedObject> columns) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            String string = this.getName(table, columns, null, (Iterable<? extends DasTypedObject>)JBIterable.empty());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName(@NotNull DasObject object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            DasForeignKey key = (DasForeignKey)ObjectUtils.tryCast((Object)object, DasForeignKey.class);
            String string = key == null ? object.getName() : this.getName(key.getTable(), key.getColumnsRef().resolveObjects(), key.getRefTable(), key.getRefColumns().resolveObjects());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate", "getName"));
            }
            return string;
        }
    }

    public static class SubstitutionBuilder {
        private String myResult;

        public SubstitutionBuilder(@NotNull String template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/util/NameTemplate$SubstitutionBuilder", "<init>"));
            }
            this.myResult = template;
        }

        public SubstitutionBuilder substitute(@NotNull Placeholder p, @NotNull String val) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/sql/util/NameTemplate$SubstitutionBuilder", "substitute"));
            }
            if (val == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/sql/util/NameTemplate$SubstitutionBuilder", "substitute"));
            }
            this.myResult = p.substitute(this.myResult, val);
            return this;
        }

        @NotNull
        public String build() {
            String string = this.myResult;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$SubstitutionBuilder", "build"));
            }
            return string;
        }
    }

    public static class RegexPlaceholder
    extends Placeholder {
        private final Pattern myPattern;

        public RegexPlaceholder(@NotNull String text, @NotNull @RegExp String regex, @NotNull String desc, @NotNull String example) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/NameTemplate$RegexPlaceholder", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/sql/util/NameTemplate$RegexPlaceholder", "<init>"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/sql/util/NameTemplate$RegexPlaceholder", "<init>"));
            }
            if (example == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "example", "com/intellij/sql/util/NameTemplate$RegexPlaceholder", "<init>"));
            }
            super(text, desc, example);
            this.myPattern = Pattern.compile(regex);
        }

        @Override
        @NotNull
        public String substitute(@NotNull String s, @NotNull String val) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/sql/util/NameTemplate$RegexPlaceholder", "substitute"));
            }
            if (val == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/sql/util/NameTemplate$RegexPlaceholder", "substitute"));
            }
            String string = this.myPattern.matcher(s).replaceAll(val);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$RegexPlaceholder", "substitute"));
            }
            return string;
        }
    }

    public static class Placeholder {
        public final String text;
        public final String desc;
        public final String example;

        public Placeholder(@NotNull String text, @NotNull String desc, @NotNull String example) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/NameTemplate$Placeholder", "<init>"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/sql/util/NameTemplate$Placeholder", "<init>"));
            }
            if (example == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "example", "com/intellij/sql/util/NameTemplate$Placeholder", "<init>"));
            }
            this.text = text;
            this.desc = desc;
            this.example = example;
        }

        @NotNull
        public String substitute(@NotNull String s, @NotNull String val) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/sql/util/NameTemplate$Placeholder", "substitute"));
            }
            if (val == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/sql/util/NameTemplate$Placeholder", "substitute"));
            }
            String string = s.replace(this.text, val);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/NameTemplate$Placeholder", "substitute"));
            }
            return string;
        }
    }
}

