/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.ArrayLinkedVariables;
import android.support.constraint.solver.Cache;
import android.support.constraint.solver.SolverVariable;

public class ArrayRow {
    private static final boolean DEBUG = false;
    static final boolean USE_LINKED_VARIABLES = true;
    SolverVariable variable = null;
    float variableValue = 0.0f;
    float constantValue = 0.0f;
    boolean used = false;
    final float epsilon = 0.001f;
    final ArrayLinkedVariables variables;
    boolean isSimpleDefinition = false;

    public ArrayRow(Cache cache) {
        this.variables = new ArrayLinkedVariables(this, cache);
    }

    public void updateClientEquations() {
        this.variables.updateClientEquations(this);
    }

    public boolean hasAtLeastOnePositiveVariable() {
        return this.variables.hasAtLeastOnePositiveVariable();
    }

    public boolean hasKeyVariable() {
        return !(this.variable == null || this.variable.mType != SolverVariable.Type.UNRESTRICTED && this.constantValue < 0.0f);
    }

    public String toString() {
        return this.toReadableString();
    }

    public String toReadableString() {
        String s = "";
        s = this.variable == null ? s + "0" : s + this.variable;
        s = s + " = ";
        boolean addedVariable = false;
        if (this.constantValue != 0.0f) {
            s = s + this.constantValue;
            addedVariable = true;
        }
        int count = this.variables.currentSize;
        for (int i = 0; i < count; ++i) {
            SolverVariable v = this.variables.getVariable(i);
            if (v == null) continue;
            float amount = this.variables.getVariableValue(i);
            String name = v.toString();
            if (!addedVariable) {
                if (amount < 0.0f) {
                    s = s + "- ";
                    amount *= -1.0f;
                }
            } else if (amount > 0.0f) {
                s = s + " + ";
            } else {
                s = s + " - ";
                amount *= -1.0f;
            }
            s = amount == 1.0f ? s + name : s + amount + " " + name;
            addedVariable = true;
        }
        if (!addedVariable) {
            s = s + "0.0";
        }
        return s;
    }

    public void reset() {
        this.variable = null;
        this.variables.clear();
        this.variableValue = 0.0f;
        this.constantValue = 0.0f;
        this.isSimpleDefinition = false;
    }

    public boolean hasVariable(SolverVariable v) {
        return this.variables.containsKey(v);
    }

    public ArrayRow createRowEquals(SolverVariable variable, int value) {
        if (value < 0) {
            this.constantValue = -1 * value;
            this.variables.put(variable, 1.0f);
        } else {
            this.constantValue = value;
            this.variables.put(variable, -1.0f);
        }
        return this;
    }

    public ArrayRow createRowEquals(SolverVariable variableA, SolverVariable variableB, int margin) {
        boolean inverse = false;
        if (margin != 0) {
            int m = margin;
            if (m < 0) {
                m = -1 * m;
                inverse = true;
            }
            this.constantValue = m;
        }
        if (!inverse) {
            this.variables.put(variableA, -1.0f);
            this.variables.put(variableB, 1.0f);
        } else {
            this.variables.put(variableA, 1.0f);
            this.variables.put(variableB, -1.0f);
        }
        return this;
    }

    public ArrayRow addSingleError(SolverVariable error, int sign) {
        this.variables.put(error, sign);
        return this;
    }

    public ArrayRow createRowGreaterThan(SolverVariable variableA, SolverVariable variableB, SolverVariable slack, int margin) {
        boolean inverse = false;
        if (margin != 0) {
            int m = margin;
            if (m < 0) {
                m = -1 * m;
                inverse = true;
            }
            this.constantValue = m;
        }
        if (!inverse) {
            this.variables.put(variableA, -1.0f);
            this.variables.put(variableB, 1.0f);
            this.variables.put(slack, 1.0f);
        } else {
            this.variables.put(variableA, 1.0f);
            this.variables.put(variableB, -1.0f);
            this.variables.put(slack, -1.0f);
        }
        return this;
    }

    public ArrayRow createRowLowerThan(SolverVariable variableA, SolverVariable variableB, SolverVariable slack, int margin) {
        boolean inverse = false;
        if (margin != 0) {
            int m = margin;
            if (m < 0) {
                m = -1 * m;
                inverse = true;
            }
            this.constantValue = m;
        }
        if (!inverse) {
            this.variables.put(variableA, -1.0f);
            this.variables.put(variableB, 1.0f);
            this.variables.put(slack, -1.0f);
        } else {
            this.variables.put(variableA, 1.0f);
            this.variables.put(variableB, -1.0f);
            this.variables.put(slack, 1.0f);
        }
        return this;
    }

    public ArrayRow createRowCentering(SolverVariable variableA, SolverVariable variableB, int marginA, float bias, SolverVariable variableC, SolverVariable variableD, int marginB, boolean withError) {
        if (variableB == variableC) {
            this.variables.put(variableA, 1.0f);
            this.variables.put(variableD, 1.0f);
            this.variables.put(variableB, -2.0f);
            return this;
        }
        if (bias == 0.5f) {
            this.variables.put(variableA, 1.0f);
            this.variables.put(variableB, -1.0f);
            this.variables.put(variableC, -1.0f);
            this.variables.put(variableD, 1.0f);
            if (marginA > 0 || marginB > 0) {
                this.constantValue = -marginA + marginB;
            }
        } else {
            this.variables.put(variableA, 1.0f * (1.0f - bias));
            this.variables.put(variableB, -1.0f * (1.0f - bias));
            this.variables.put(variableC, -1.0f * bias);
            this.variables.put(variableD, 1.0f * bias);
            if (marginA > 0 || marginB > 0) {
                this.constantValue = (float)(-marginA) * (1.0f - bias) + (float)marginB * bias;
            }
        }
        return this;
    }

    public ArrayRow addError(SolverVariable error1, SolverVariable error2) {
        this.variables.put(error1, 1.0f);
        this.variables.put(error2, -1.0f);
        return this;
    }

    public ArrayRow createRowDimensionPercent(SolverVariable variableA, SolverVariable variableB, SolverVariable variableC, float percent) {
        this.variables.put(variableA, -1.0f);
        this.variables.put(variableB, 1.0f - percent);
        this.variables.put(variableC, percent);
        return this;
    }

    public ArrayRow createRowDimensionRatio(SolverVariable variableA, SolverVariable variableB, SolverVariable variableC, SolverVariable variableD, float ratio) {
        this.variables.put(variableA, -1.0f);
        this.variables.put(variableB, 1.0f);
        this.variables.put(variableC, ratio);
        this.variables.put(variableD, -ratio);
        return this;
    }

    public int sizeInBytes() {
        int size = 0;
        if (this.variable != null) {
            size += 4;
        }
        size += 4;
        size += 4;
        size += 4;
        return size += this.variables.sizeInBytes();
    }

    public boolean updateRowWithEquation(ArrayRow definition) {
        this.variables.updateFromRow(this, definition);
        return true;
    }

    public void ensurePositiveConstant() {
        if (this.constantValue < 0.0f) {
            this.constantValue *= -1.0f;
            this.variables.invert();
            return;
        }
    }

    public void pickRowVariable() {
        SolverVariable pivotCandidate = this.variables.pickPivotCandidate();
        if (pivotCandidate != null) {
            this.pivot(pivotCandidate);
        }
        if (this.variables.currentSize == 0) {
            this.isSimpleDefinition = true;
        }
    }

    public void pivot(SolverVariable v) {
        if (this.variable != null) {
            this.variables.put(this.variable, -1.0f);
            this.variable = null;
        }
        float amount = this.variables.remove(v) * -1.0f;
        this.variable = v;
        this.variableValue = 1.0f;
        if (amount == 1.0f) {
            return;
        }
        this.constantValue /= amount;
        this.variables.divideByAmount(amount);
    }
}

