/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.Rectangle;
import android.support.constraint.solver.widgets.Snapshot;
import android.support.constraint.solver.widgets.WidgetContainer;
import java.util.ArrayList;
import java.util.Arrays;

public class ConstraintWidgetContainer
extends WidgetContainer {
    private static final boolean USE_THREAD = false;
    private static final boolean DEBUG = false;
    private static final boolean USE_SNAPSHOT = true;
    protected LinearSystem mSystem = new LinearSystem();
    protected LinearSystem mBackgroundSystem = null;
    private Snapshot mSnapshot;
    static boolean ALLOW_ROOT_GROUP = true;
    int mWrapWidth;
    int mWrapHeight;
    int mPaddingLeft;
    int mPaddingTop;
    int mPaddingRight;
    int mPaddingBottom;

    public ConstraintWidgetContainer() {
    }

    public ConstraintWidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public ConstraintWidgetContainer(int width, int height) {
        super(width, height);
    }

    @Override
    public String getType() {
        return "ConstraintLayout";
    }

    @Override
    public void reset() {
        this.mSystem.reset();
        this.mPaddingLeft = 0;
        this.mPaddingRight = 0;
        this.mPaddingTop = 0;
        this.mPaddingBottom = 0;
        super.reset();
    }

    public static ConstraintWidgetContainer createContainer(ConstraintWidgetContainer container, String name, ArrayList<ConstraintWidget> widgets, int padding) {
        Rectangle bounds = ConstraintWidgetContainer.getBounds(widgets);
        if (bounds.width == 0 || bounds.height == 0) {
            return null;
        }
        if (padding > 0) {
            int maxPadding = Math.min(bounds.x, bounds.y);
            if (padding > maxPadding) {
                padding = maxPadding;
            }
            bounds.grow(padding, padding);
        }
        container.setOrigin(bounds.x, bounds.y);
        container.setDimension(bounds.width, bounds.height);
        container.setDebugName(name);
        ConstraintWidget parent = widgets.get(0).getParent();
        int widgetsSize = widgets.size();
        for (int i = 0; i < widgetsSize; ++i) {
            ConstraintWidget widget = widgets.get(i);
            if (widget.getParent() != parent) continue;
            container.add(widget);
            widget.setX(widget.getX() - bounds.x);
            widget.setY(widget.getY() - bounds.y);
        }
        return container;
    }

    public void addChildrenToSolver(LinearSystem system, int group) {
        this.addToSolver(system, group);
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (widget instanceof ConstraintWidgetContainer) {
                ConstraintWidget.DimensionBehaviour horizontalBehaviour = widget.getHorizontalDimensionBehaviour();
                ConstraintWidget.DimensionBehaviour verticalBehaviour = widget.getVerticalDimensionBehaviour();
                if (horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                }
                if (verticalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                }
                widget.addToSolver(system, group);
                if (horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setHorizontalDimensionBehaviour(horizontalBehaviour);
                }
                if (verticalBehaviour != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) continue;
                widget.setVerticalDimensionBehaviour(verticalBehaviour);
                continue;
            }
            widget.addToSolver(system, group);
        }
    }

    public void updateChildrenFromSolver(LinearSystem system, int group) {
        this.updateFromSolver(system, group);
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            widget.updateFromSolver(system, group);
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
    }

    @Override
    public void layout() {
        int prex = this.mX;
        int prey = this.mY;
        int prew = this.getWidth();
        int preh = this.getHeight();
        if (this.mParent != null) {
            if (this.mSnapshot == null) {
                this.mSnapshot = new Snapshot(this);
            }
            this.mSnapshot.updateFrom(this);
            this.setX(this.mPaddingLeft);
            this.setY(this.mPaddingTop);
            this.resetAnchors();
            this.resetSolverVariables(this.mSystem.getCache());
        } else {
            this.mX = 0;
            this.mY = 0;
        }
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
        try {
            this.mSystem.reset();
            this.addChildrenToSolver(this.mSystem, Integer.MAX_VALUE);
            this.mSystem.minimize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateChildrenFromSolver(this.mSystem, Integer.MAX_VALUE);
        if (this.mParent != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            this.mSnapshot.applyTo(this);
            this.setWidth(width + this.mPaddingLeft + this.mPaddingRight);
            this.setHeight(height + this.mPaddingTop + this.mPaddingBottom);
        } else {
            this.mX = prex;
            this.mY = prey;
            this.setWidth(prew);
            this.setHeight(preh);
        }
        this.resetSolverVariables(this.mSystem.getCache());
        if (this == this.getRootConstraintContainer()) {
            this.updateDrawPosition();
        }
    }

    static int setGroup(ConstraintAnchor anchor, int group) {
        int oldGroup = anchor.mGroup;
        if (anchor.mOwner.getParent() == null) {
            return group;
        }
        if (oldGroup <= group) {
            return oldGroup;
        }
        anchor.mGroup = group;
        ConstraintAnchor opposite = anchor.getOpposite();
        ConstraintAnchor target = anchor.mTarget;
        group = opposite != null ? ConstraintWidgetContainer.setGroup(opposite, group) : group;
        group = target != null ? ConstraintWidgetContainer.setGroup(target, group) : group;
        anchor.mGroup = group = opposite != null ? ConstraintWidgetContainer.setGroup(opposite, group) : group;
        return group;
    }

    public int layoutFindGroupsSimple() {
        int size = this.mChildren.size();
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            widget.mLeft.mGroup = 0;
            widget.mRight.mGroup = 0;
            widget.mTop.mGroup = 1;
            widget.mBottom.mGroup = 1;
            widget.mBaseline.mGroup = 1;
        }
        return 2;
    }

    public void findWrapRecursive(ConstraintWidget widget) {
        int h;
        int w;
        int distToRight = w = widget.getWrapWidth();
        int distToLeft = w;
        ConstraintWidget leftWidget = null;
        ConstraintWidget rightWidget = null;
        widget.mVisited = true;
        if (!widget.mRight.isConnected() && !widget.mLeft.isConnected()) {
            distToLeft += widget.getX();
        } else {
            if (widget.mRight.mTarget != null) {
                rightWidget = widget.mRight.mTarget.getOwner();
                distToRight += widget.mRight.getMargin();
                if (!rightWidget.isRoot() && !rightWidget.mVisited) {
                    this.findWrapRecursive(rightWidget);
                }
            }
            if (widget.mLeft.isConnected()) {
                leftWidget = widget.mLeft.mTarget.getOwner();
                distToLeft += widget.mLeft.getMargin();
                if (!leftWidget.isRoot() && !leftWidget.mVisited) {
                    this.findWrapRecursive(leftWidget);
                }
            }
            if (widget.mRight.mTarget != null && !rightWidget.isRoot()) {
                if (widget.mRight.mTarget.mType == ConstraintAnchor.Type.RIGHT) {
                    distToRight += rightWidget.mDistToRight - rightWidget.getWrapWidth();
                } else if (widget.mRight.mTarget.getType() == ConstraintAnchor.Type.LEFT) {
                    distToRight += rightWidget.mDistToRight;
                }
            }
            if (widget.mLeft.mTarget != null && !leftWidget.isRoot()) {
                if (widget.mLeft.mTarget.getType() == ConstraintAnchor.Type.LEFT) {
                    distToLeft += leftWidget.mDistToLeft - leftWidget.getWrapWidth();
                } else if (widget.mLeft.mTarget.getType() == ConstraintAnchor.Type.RIGHT) {
                    distToLeft += leftWidget.mDistToLeft;
                }
            }
        }
        widget.mDistToLeft = distToLeft;
        widget.mDistToRight = distToRight;
        int distToTop = h = widget.getWrapHeight();
        int distToBottom = h;
        ConstraintWidget topWidget = null;
        if (widget.mBaseline.mTarget == null && widget.mTop.mTarget == null && widget.mBottom.mTarget == null) {
            distToTop += widget.getY();
        } else {
            if (widget.mBaseline.isConnected()) {
                ConstraintWidget baseLineWidget = widget.mBaseline.mTarget.getOwner();
                if (!baseLineWidget.mVisited) {
                    this.findWrapRecursive(baseLineWidget);
                }
                if (baseLineWidget.mDistToBottom > distToBottom) {
                    distToBottom = baseLineWidget.mDistToBottom;
                }
                if (baseLineWidget.mDistToTop > distToTop) {
                    distToTop = baseLineWidget.mDistToTop;
                }
                widget.mDistToTop = distToTop;
                widget.mDistToBottom = distToBottom;
                return;
            }
            if (widget.mTop.isConnected()) {
                topWidget = widget.mTop.mTarget.getOwner();
                distToTop += widget.mTop.getMargin();
                if (!topWidget.isRoot() && !topWidget.mVisited) {
                    this.findWrapRecursive(topWidget);
                }
            }
            ConstraintWidget bottomWidget = null;
            if (widget.mBottom.isConnected()) {
                bottomWidget = widget.mBottom.mTarget.getOwner();
                distToBottom += widget.mBottom.getMargin();
                if (!bottomWidget.isRoot() && !bottomWidget.mVisited) {
                    this.findWrapRecursive(bottomWidget);
                }
            }
            if (widget.mTop.mTarget != null && !topWidget.isRoot()) {
                if (widget.mTop.mTarget.getType() == ConstraintAnchor.Type.TOP) {
                    distToTop += topWidget.mDistToTop - topWidget.getWrapHeight();
                } else if (widget.mTop.mTarget.getType() == ConstraintAnchor.Type.BOTTOM) {
                    distToTop += topWidget.mDistToTop;
                }
            }
            if (widget.mBottom.mTarget != null && !bottomWidget.isRoot()) {
                if (widget.mBottom.mTarget.getType() == ConstraintAnchor.Type.BOTTOM) {
                    distToBottom += bottomWidget.mDistToBottom - bottomWidget.getWrapHeight();
                } else if (widget.mBottom.mTarget.getType() == ConstraintAnchor.Type.TOP) {
                    distToBottom += bottomWidget.mDistToBottom;
                }
            }
        }
        widget.mDistToTop = distToTop;
        widget.mDistToBottom = distToBottom;
    }

    public void findWrapSize(ArrayList<ConstraintWidget> children) {
        int maxTopDist = 0;
        int maxLeftDist = 0;
        int maxRightDist = 0;
        int maxBottomDist = 0;
        int maxConnectWidth = 0;
        int maxConnectHeight = 0;
        int size = children.size();
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = children.get(j);
            if (widget.isRoot()) continue;
            if (!widget.mVisited) {
                this.findWrapRecursive(widget);
            }
            int connectWidth = widget.mDistToLeft + widget.mDistToRight - widget.getWrapWidth();
            int connectHeight = widget.mDistToTop + widget.mDistToBottom - widget.getWrapHeight();
            maxLeftDist = Math.max(maxLeftDist, widget.mDistToLeft);
            maxRightDist = Math.max(maxRightDist, widget.mDistToRight);
            maxBottomDist = Math.max(maxBottomDist, widget.mDistToBottom);
            maxTopDist = Math.max(maxTopDist, widget.mDistToTop);
            maxConnectWidth = Math.max(maxConnectWidth, connectWidth);
            maxConnectHeight = Math.max(maxConnectHeight, connectHeight);
        }
        int max = Math.max(maxLeftDist, maxRightDist);
        this.mWrapWidth = Math.max(max, maxConnectWidth);
        max = Math.max(maxTopDist, maxBottomDist);
        this.mWrapHeight = Math.max(max, maxConnectHeight);
        for (int j = 0; j < size; ++j) {
            children.get((int)j).mVisited = false;
        }
    }

    public int layoutFindGroups() {
        ConstraintAnchor anchor;
        ConstraintAnchor.Type[] dir = new ConstraintAnchor.Type[]{ConstraintAnchor.Type.LEFT, ConstraintAnchor.Type.RIGHT, ConstraintAnchor.Type.TOP, ConstraintAnchor.Type.BASELINE, ConstraintAnchor.Type.BOTTOM};
        int label = 1;
        int size = this.mChildren.size();
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            ConstraintAnchor anchor2 = null;
            anchor2 = widget.mLeft;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mTop;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mRight;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mBottom;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mBaseline;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) != label) continue;
                ++label;
                continue;
            }
            anchor2.mGroup = Integer.MAX_VALUE;
        }
        boolean notDone = true;
        int count = 0;
        int fix = 0;
        while (notDone) {
            notDone = false;
            ++count;
            for (int j = 0; j < size; ++j) {
                ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
                for (int i = 0; i < dir.length; ++i) {
                    ConstraintAnchor opposite;
                    ConstraintAnchor.Type type = dir[i];
                    anchor = null;
                    switch (type) {
                        case LEFT: {
                            anchor = widget.mLeft;
                            break;
                        }
                        case TOP: {
                            anchor = widget.mTop;
                            break;
                        }
                        case RIGHT: {
                            anchor = widget.mRight;
                            break;
                        }
                        case BOTTOM: {
                            anchor = widget.mBottom;
                            break;
                        }
                        case BASELINE: {
                            anchor = widget.mBaseline;
                        }
                    }
                    ConstraintAnchor target = anchor.mTarget;
                    if (target == null) continue;
                    if (target.mOwner.getParent() != null && target.mGroup != anchor.mGroup) {
                        anchor.mGroup = anchor.mGroup > target.mGroup ? target.mGroup : anchor.mGroup;
                        target.mGroup = anchor.mGroup;
                        ++fix;
                        notDone = true;
                    }
                    if ((opposite = target.getOpposite()) == null || opposite.mGroup == anchor.mGroup) continue;
                    anchor.mGroup = anchor.mGroup > opposite.mGroup ? opposite.mGroup : anchor.mGroup;
                    opposite.mGroup = anchor.mGroup;
                    ++fix;
                    notDone = true;
                }
            }
        }
        int index = 0;
        int[] table = new int[this.mChildren.size() * dir.length + 1];
        Arrays.fill(table, -1);
        for (int j = 0; j < size; ++j) {
            int g;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            anchor = null;
            anchor = widget.mLeft;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mTop;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mRight;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mBottom;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mBaseline;
            if (anchor.mGroup == Integer.MAX_VALUE) continue;
            g = anchor.mGroup;
            if (table[g] == -1) {
                table[g] = index++;
            }
            anchor.mGroup = table[g];
        }
        return index;
    }

    public void layoutWithGroup(int numOfGroups) {
        int i;
        int prex = this.mX;
        int prey = this.mY;
        if (this.mParent != null) {
            if (this.mSnapshot == null) {
                this.mSnapshot = new Snapshot(this);
            }
            this.mSnapshot.updateFrom(this);
            this.mX = 0;
            this.mY = 0;
            this.resetAnchors();
            this.resetSolverVariables(this.mSystem.getCache());
        } else {
            this.mX = 0;
            this.mY = 0;
        }
        int count = this.mChildren.size();
        for (i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
        this.mLeft.mGroup = 0;
        this.mRight.mGroup = 0;
        this.mTop.mGroup = 1;
        this.mBottom.mGroup = 1;
        this.mSystem.reset();
        for (i = 0; i < numOfGroups; ++i) {
            try {
                this.addToSolver(this.mSystem, i);
                this.mSystem.minimize();
                this.updateFromSolver(this.mSystem, i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateFromSolver(this.mSystem, -2);
        }
        if (this.mParent != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            this.mSnapshot.applyTo(this);
            this.setWidth(width);
            this.setHeight(height);
        } else {
            this.mX = prex;
            this.mY = prey;
        }
        if (this == this.getRootConstraintContainer()) {
            this.updateDrawPosition();
        }
    }

    @Override
    public boolean isAnimating() {
        if (super.isAnimating()) {
            return true;
        }
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!widget.isAnimating()) continue;
            return true;
        }
        return false;
    }

    public boolean handlesInternalConstraints() {
        return false;
    }

    public ArrayList<Guideline> getVerticalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 1) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public ArrayList<Guideline> getHorizontalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 0) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public LinearSystem getSystem() {
        return this.mSystem;
    }
}

