/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamFactory;
import com.intellij.seam.model.jam.bijection.SeamJamBijection;
import com.intellij.seam.model.jam.bijection.SeamJamInjection;
import com.intellij.seam.model.jam.bijection.SeamJamOutjection;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.seam.utils.beans.ContextVariable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamBijectionIllegalScopeParameterInspection
extends SeamJamModelInspectionBase {
    @Override
    protected void checkSeamJamComponent(SeamJamComponent seamJamComponent, ProblemsHolder holder) {
        Module module = seamJamComponent.getModule();
        for (SeamJamInjection injection : seamJamComponent.getInjections()) {
            SeamBijectionIllegalScopeParameterInspection.checkInjectionIllegalScopeParameter(holder, injection);
        }
        for (SeamJamOutjection outjection : seamJamComponent.getOutjections()) {
            SeamBijectionIllegalScopeParameterInspection.checkOutjectionIllegalScopeParameter(holder, outjection, module);
        }
    }

    private static void checkInjectionIllegalScopeParameter(ProblemsHolder holder, SeamJamInjection injection) {
        SeamComponentScope scope = injection.getScope();
        if (scope == null || scope.isEqual(SeamComponentScope.UNSPECIFIED)) {
            return;
        }
        if (injection.isCreate()) {
            holder.registerProblem((PsiElement)injection.getIdentifyingAnnotation(), SeamInspectionBundle.message("bijection.injection.illegal.scope.declaration", new Object[0]), new LocalQuickFix[0]);
        }
    }

    protected static void checkOutjectionIllegalScopeParameter(ProblemsHolder holder, SeamJamBijection outjection, Module module) {
        ContextVariable contextVariable;
        SeamComponentScope scope = outjection.getScope();
        if (scope == null || scope.isEqual(SeamComponentScope.UNSPECIFIED)) {
            return;
        }
        String variableName = outjection.getName();
        if (!(variableName == null || SeamCommonUtils.isElText(variableName) || (contextVariable = SeamBijectionIllegalScopeParameterInspection.getContextVariable(variableName, module)) == null || ((Object)((Object)outjection)).equals(contextVariable.getModelElement()) || contextVariable.getModelElement() instanceof SeamJamFactory)) {
            holder.registerProblem((PsiElement)outjection.getIdentifyingAnnotation(), SeamInspectionBundle.message("bijection.outjection.illegal.scope.declaration", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    protected static ContextVariable getContextVariable(String variableName, Module module) {
        for (ContextVariable variable : SeamCommonUtils.getSeamContextVariablesWithDependencies(module)) {
            if (!variableName.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("bijection.illegal.scope.parameter.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamBijectionIllegalScopeParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamBijectionIllegalScopeParameterInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamBijectionIllegalScopeParameterInspection", "getShortName"));
        }
        return "SeamBijectionIllegalScopeParameterInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamBijectionIllegalScopeParameterInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

