/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.uibuilder.api.XmlBuilder;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlEndElementChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceEndChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceStartChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlResourceMapChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryXmlParser {
    @NotNull
    public static byte[] decodeXml(@NotNull String fileName, @NotNull byte[] bytes) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "decodeXml"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "decodeXml"));
        }
        BinaryResourceFile file = new BinaryResourceFile(bytes);
        List chunks = file.getChunks();
        if (chunks.size() != 1) {
            Logger.getInstance(BinaryXmlParser.class).warn("Expected 1, but got " + chunks.size() + " chunks while parsing " + fileName);
            if (bytes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "decodeXml"));
            }
            return bytes;
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            Logger.getInstance(BinaryXmlParser.class).warn("First chunk in " + fileName + " is not an XmlChunk: " + ((Chunk)chunks.get(0)).getClass().getCanonicalName());
            if (bytes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "decodeXml"));
            }
            return bytes;
        }
        XmlPrinter printer = new XmlPrinter();
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        BinaryXmlParser.visitChunks(xmlChunk.getChunks(), printer);
        String reconstructedXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + printer.getReconstructedXml();
        byte[] byArray = reconstructedXml.getBytes(Charsets.UTF_8);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "decodeXml"));
        }
        return byArray;
    }

    private static void visitChunks(@NotNull Map<Integer, Chunk> chunks, @NotNull XmlChunkHandler handler) {
        if (chunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunks", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "visitChunks"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "visitChunks"));
        }
        List<Chunk> contentChunks = BinaryXmlParser.sortByOffset(chunks);
        for (Chunk chunk : contentChunks) {
            if (chunk instanceof StringPoolChunk) {
                handler.stringPool((StringPoolChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlResourceMapChunk) {
                handler.xmlResourceMap((XmlResourceMapChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceStartChunk) {
                handler.startNamespace((XmlNamespaceStartChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceEndChunk) {
                handler.endNamespace((XmlNamespaceEndChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlStartElementChunk) {
                handler.startElement((XmlStartElementChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlEndElementChunk) {
                handler.endElement((XmlEndElementChunk)chunk);
                continue;
            }
            Logger.getInstance(BinaryXmlParser.class).warn("XmlNode of type " + chunk.getClass().getCanonicalName() + " not handled.");
        }
    }

    @NotNull
    private static List<Chunk> sortByOffset(Map<Integer, Chunk> contentChunks) {
        ArrayList offsets = Lists.newArrayList(contentChunks.keySet());
        Collections.sort(offsets);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(offsets.size());
        for (Integer offset : offsets) {
            chunks.add(contentChunks.get(offset));
        }
        ArrayList<Chunk> arrayList = chunks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "sortByOffset"));
        }
        return arrayList;
    }

    public static String formatValue(@NotNull BinaryResourceValue resValue, @Nullable StringPoolChunk stringPool) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/apk/viewer/BinaryXmlParser", "formatValue"));
        }
        int data = resValue.data();
        switch (resValue.type()) {
            case NULL: {
                return "null";
            }
            case DYNAMIC_REFERENCE: {
                return String.format(Locale.US, "@dref/0x%1$08x", data);
            }
            case REFERENCE: {
                return String.format(Locale.US, "@ref/0x%1$08x", data);
            }
            case ATTRIBUTE: {
                return String.format(Locale.US, "@attr/0x%1$x", data);
            }
            case STRING: {
                return stringPool != null && stringPool.getStringCount() < data ? stringPool.getString(data) : String.format(Locale.US, "@string/0x%1$x", data);
            }
            case DIMENSION: {
                return String.format(Locale.US, "dimension(%1$d)", data);
            }
            case FRACTION: {
                return String.format(Locale.US, "fraction(%1$d)", data);
            }
            case FLOAT: {
                return String.format(Locale.US, "%f", Float.valueOf(data));
            }
            case INT_DEC: {
                return Integer.toString(data);
            }
            case INT_HEX: {
                return "0x" + Integer.toHexString(data);
            }
            case INT_BOOLEAN: {
                return Boolean.toString(data != 0);
            }
            case INT_COLOR_ARGB8: {
                return String.format("argb8(0x%x)", data);
            }
            case INT_COLOR_RGB8: {
                return String.format("rgb8(0x%x)", data);
            }
            case INT_COLOR_ARGB4: {
                return String.format("argb4(0x%x)", data);
            }
            case INT_COLOR_RGB4: {
                return String.format("rgb4(0x%x)", data);
            }
        }
        return String.format("@res/0x%x", data);
    }

    private static class XmlPrinter
    implements XmlChunkHandler {
        private final XmlBuilder myBuilder;
        private Map<String, String> myNamespaces = new HashMap<String, String>();
        private boolean myNamespacesAdded;
        private StringPoolChunk myStringPool;

        public XmlPrinter() {
            this.myBuilder = new XmlBuilder();
        }

        @Override
        public void stringPool(@NotNull StringPoolChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter", "stringPool"));
            }
            this.myStringPool = chunk;
        }

        @Override
        public void startNamespace(@NotNull XmlNamespaceStartChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter", "startNamespace"));
            }
            this.myNamespaces.put(chunk.getUri(), chunk.getPrefix());
        }

        @Override
        public void startElement(@NotNull XmlStartElementChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter", "startElement"));
            }
            this.myBuilder.startTag(chunk.getName());
            if (!this.myNamespacesAdded && !this.myNamespaces.isEmpty()) {
                this.myNamespacesAdded = true;
                for (Map.Entry entry : this.myNamespaces.entrySet()) {
                    this.myBuilder.attribute("xmlns", (String)entry.getValue(), (String)entry.getKey());
                }
            }
            for (XmlAttribute xmlAttribute : chunk.getAttributes()) {
                String prefix = StringUtil.notNullize((String)this.myNamespaces.get(xmlAttribute.namespace()));
                this.myBuilder.attribute(prefix, xmlAttribute.name(), this.getValue(xmlAttribute));
            }
        }

        @Override
        public void endElement(@NotNull XmlEndElementChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter", "endElement"));
            }
            this.myBuilder.endTag(chunk.getName());
        }

        @NotNull
        public String getReconstructedXml() {
            String string = this.myBuilder.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter", "getReconstructedXml"));
            }
            return string;
        }

        @NotNull
        private String getValue(@NotNull XmlAttribute attribute) {
            if (attribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter", "getValue"));
            }
            String rawValue = attribute.rawValue();
            if (!StringUtil.isEmpty((String)rawValue)) {
                String string = rawValue;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter", "getValue"));
                }
                return string;
            }
            BinaryResourceValue resValue = attribute.typedValue();
            String string = BinaryXmlParser.formatValue(resValue, this.myStringPool);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlPrinter", "getValue"));
            }
            return string;
        }
    }

    private static interface XmlChunkHandler {
        default public void stringPool(@NotNull StringPoolChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlChunkHandler", "stringPool"));
            }
        }

        default public void xmlResourceMap(@NotNull XmlResourceMapChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlChunkHandler", "xmlResourceMap"));
            }
        }

        default public void startNamespace(@NotNull XmlNamespaceStartChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlChunkHandler", "startNamespace"));
            }
        }

        default public void endNamespace(@NotNull XmlNamespaceEndChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlChunkHandler", "endNamespace"));
            }
        }

        default public void startElement(@NotNull XmlStartElementChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlChunkHandler", "startElement"));
            }
        }

        default public void endElement(@NotNull XmlEndElementChunk chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/android/tools/idea/apk/viewer/BinaryXmlParser$XmlChunkHandler", "endElement"));
            }
        }
    }
}

