/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.idea.apk.viewer.dex.PackageTreeNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.iface.reference.MethodReference;

public class DexParser {
    private final ListeningExecutorService myExecutor;
    private final Future<DexBackedDexFile> myDexFileFuture;

    public DexParser(@NotNull ListeningExecutorService executorService, @NotNull VirtualFile file) {
        if (executorService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorService", "com/android/tools/idea/apk/viewer/dex/DexParser", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/viewer/dex/DexParser", "<init>"));
        }
        this.myExecutor = executorService;
        this.myDexFileFuture = this.myExecutor.submit(() -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/viewer/dex/DexParser", "lambda$new$0"));
            }
            return DexParser.getDexFile(file);
        });
    }

    public ListenableFuture<PackageTreeNode> constructMethodRefCountTree() {
        return this.myExecutor.submit(this::constructMethodRefTree);
    }

    public ListenableFuture<DexFileStats> getDexFileStats() {
        return this.myExecutor.submit(this::getDexStats);
    }

    @NotNull
    private PackageTreeNode constructMethodRefTree() {
        DexBackedDexFile dexFile;
        try {
            dexFile = this.myDexFileFuture.get();
        }
        catch (Exception e) {
            PackageTreeNode packageTreeNode = new PackageTreeNode("Unknown", e.toString(), PackageTreeNode.NodeType.PACKAGE, null);
            if (packageTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexParser", "constructMethodRefTree"));
            }
            return packageTreeNode;
        }
        PackageTreeNode packageTreeNode = DexParser.constructMethodRefTreeForDex(dexFile);
        if (packageTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexParser", "constructMethodRefTree"));
        }
        return packageTreeNode;
    }

    @NotNull
    static PackageTreeNode constructMethodRefTreeForDex(@NotNull DexBackedDexFile dexFile) {
        if (dexFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dexFile", "com/android/tools/idea/apk/viewer/dex/DexParser", "constructMethodRefTreeForDex"));
        }
        PackageTreeNode root = new PackageTreeNode("", "root", PackageTreeNode.NodeType.PACKAGE, null);
        Set classesWithDefinition = dexFile.getClasses().stream().map(DexBackedClassDef::getType).collect(Collectors.toSet());
        Multimap<String, MethodReference> methodsByClassName = DexParser.getMethodsByClassName(dexFile);
        for (String className : methodsByClassName.keySet()) {
            Collection methods = methodsByClassName.get((Object)className);
            for (MethodReference ref : methods) {
                root.insert("", DebuggerUtilsEx.signatureToName((String)className), ref, classesWithDefinition.contains(className));
            }
        }
        root.sortByCount();
        PackageTreeNode packageTreeNode = root;
        if (packageTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexParser", "constructMethodRefTreeForDex"));
        }
        return packageTreeNode;
    }

    @NotNull
    private static Multimap<String, MethodReference> getMethodsByClassName(@NotNull DexBackedDexFile dexFile) {
        if (dexFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dexFile", "com/android/tools/idea/apk/viewer/dex/DexParser", "getMethodsByClassName"));
        }
        ArrayListMultimap methodsByClass = ArrayListMultimap.create();
        int m = dexFile.getMethodCount();
        for (int i = 0; i < m; ++i) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i);
            methodsByClass.put((Object)methodRef.getDefiningClass(), (Object)methodRef);
        }
        ArrayListMultimap arrayListMultimap = methodsByClass;
        if (arrayListMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexParser", "getMethodsByClassName"));
        }
        return arrayListMultimap;
    }

    @NotNull
    private DexFileStats getDexStats() {
        DexBackedDexFile dexFile;
        try {
            dexFile = this.myDexFileFuture.get();
        }
        catch (Exception e) {
            DexFileStats dexFileStats = new DexFileStats(-1, -1, -1);
            if (dexFileStats == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexParser", "getDexStats"));
            }
            return dexFileStats;
        }
        int definedMethodCount = 0;
        Set classes = dexFile.getClasses();
        for (DexBackedClassDef dexBackedClassDef : classes) {
            definedMethodCount += Iterables.size((Iterable)dexBackedClassDef.getMethods());
        }
        DexFileStats dexFileStats = new DexFileStats(classes.size(), definedMethodCount, dexFile.getMethodCount());
        if (dexFileStats == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexParser", "getDexStats"));
        }
        return dexFileStats;
    }

    @NotNull
    private static DexBackedDexFile getDexFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/viewer/dex/DexParser", "getDexFile"));
        }
        byte[] contents = file.contentsToByteArray();
        DexBackedDexFile dexBackedDexFile = DexParser.getDexFile(contents);
        if (dexBackedDexFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexParser", "getDexFile"));
        }
        return dexBackedDexFile;
    }

    @NotNull
    static DexBackedDexFile getDexFile(@NotNull byte[] contents) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/android/tools/idea/apk/viewer/dex/DexParser", "getDexFile"));
        }
        DexBackedDexFile dexBackedDexFile = new DexBackedDexFile(new Opcodes(15), contents);
        if (dexBackedDexFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/DexParser", "getDexFile"));
        }
        return dexBackedDexFile;
    }

    public static class DexFileStats {
        public final int classCount;
        public final int definedMethodCount;
        public final int referencedMethodCount;

        private DexFileStats(int classCount, int definedMethodCount, int referencedMethodCount) {
            this.classCount = classCount;
            this.definedMethodCount = definedMethodCount;
            this.referencedMethodCount = referencedMethodCount;
        }
    }
}

