/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.nodes.AbstractTreeNode;
import com.android.tools.idea.editors.allocations.nodes.AllocNode;
import com.android.tools.idea.editors.allocations.nodes.StackNode;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class StackSourceNode
extends AbstractTreeNode {
    @NotNull
    protected Map<StackTraceElement, StackNode> myChildrenMap = new HashMap<StackTraceElement, StackNode>();

    public void insert(AllocationInfo alloc, int depth) {
        StackTraceElement[] stack = alloc.getStackTrace();
        if (depth < stack.length) {
            StackTraceElement element = stack[stack.length - 1 - depth];
            StackNode child = this.myChildrenMap.get(element);
            if (child == null) {
                child = new StackNode(element);
                this.myChildrenMap.put(element, child);
                this.addChild(child);
            }
            child.insert(alloc, depth + 1);
        } else {
            AllocNode allocNode = new AllocNode(alloc);
            this.addChild(allocNode);
        }
    }
}

