/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.gl;

import com.android.tools.idea.editors.gfxtrace.viewer.gl.Util;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.jogamp.opengl.GL2ES2;
import java.util.Arrays;
import java.util.Map;

public class Shader {
    private static Logger LOG = Logger.getInstance(Shader.class);
    private final GL2ES2 myGl;
    private final int myHandle;
    private final Map<String, Attribute> myAttributes = Maps.newHashMap();
    private final Map<String, Uniform> myUniforms = Maps.newHashMap();

    public Shader(GL2ES2 gl) {
        this.myGl = gl;
        this.myHandle = gl.glCreateProgram();
    }

    public boolean link(String vertexSource, String fragmentSource) {
        this.detachShaders();
        if (!this.attachShaders(vertexSource, fragmentSource) || !this.link()) {
            return false;
        }
        this.getAttributes();
        this.getUniforms();
        return true;
    }

    public void bind() {
        this.myGl.glUseProgram(this.myHandle);
    }

    public void setUniform(String name, Object value) {
        Uniform uniform = this.myUniforms.get(name);
        if (uniform != null && !uniform.set(value)) {
            LOG.warn("Unexpected uniform value: " + value + " (" + value.getClass() + ") for " + name);
        }
    }

    public void setAttribute(String name, float x, float y, float z) {
        Attribute attribute = this.myAttributes.get(name);
        if (attribute != null) {
            attribute.set(this.myGl, x, y, z);
        }
    }

    public void bindAttribute(String name, int elementSize, int elementType, int strideBytes, int offsetBytes) {
        Attribute attribute = this.myAttributes.get(name);
        if (attribute != null) {
            attribute.bind(this.myGl, elementSize, elementType, strideBytes, offsetBytes);
        }
    }

    public void unbindAttribute(String name) {
        Attribute attribute = this.myAttributes.get(name);
        if (attribute != null) {
            attribute.unbind(this.myGl);
        }
    }

    public void delete() {
        this.detachShaders();
        this.myGl.glDeleteProgram(this.myHandle);
        this.myAttributes.clear();
        this.myUniforms.clear();
    }

    private void detachShaders() {
        int[] shaders = Util.getAttachedShaders(this.myGl, this.myHandle);
        for (int i = 0; i < shaders.length; ++i) {
            this.myGl.glDetachShader(this.myHandle, shaders[i]);
            this.myGl.glDeleteShader(shaders[i]);
        }
    }

    private boolean attachShaders(String vertexSource, String fragmentSource) {
        int vertexShader = Shader.createShader(this.myGl, 35633, vertexSource);
        if (vertexShader < 0) {
            return false;
        }
        int fragmentShader = Shader.createShader(this.myGl, 35632, fragmentSource);
        if (fragmentShader < 0) {
            this.myGl.glDeleteShader(vertexShader);
            return false;
        }
        this.myGl.glAttachShader(this.myHandle, vertexShader);
        this.myGl.glAttachShader(this.myHandle, fragmentShader);
        return true;
    }

    private boolean link() {
        this.myGl.glLinkProgram(this.myHandle);
        if (Util.getProgramiv(this.myGl, this.myHandle, 35714) != 1) {
            LOG.warn("Failed to link program:\n" + Util.getProgramInfoLog(this.myGl, this.myHandle));
            return false;
        }
        return true;
    }

    private void getAttributes() {
        this.myAttributes.clear();
        for (Util.AttributeOrUniform attribute : Util.getActiveAttributes(this.myGl, this.myHandle)) {
            this.myAttributes.put(attribute.name, new Attribute(attribute));
        }
    }

    private void getUniforms() {
        this.myUniforms.clear();
        for (Util.AttributeOrUniform uniform : Util.getActiveUniforms(this.myGl, this.myHandle)) {
            this.myUniforms.put(uniform.name, new Uniform(this.myGl, uniform));
        }
    }

    private static int createShader(GL2ES2 gl, int type, String source) {
        int shader = gl.glCreateShader(type);
        gl.glShaderSource(shader, 1, new String[]{source}, null, 0);
        gl.glCompileShader(shader);
        if (Util.getShaderiv(gl, shader, 35713) != 1) {
            LOG.warn("Failed to compile shader:\n" + Util.getShaderInfoLog(gl, shader) + "\n\nSource:\n" + source);
            gl.glDeleteShader(shader);
            return -1;
        }
        return shader;
    }

    private static class Uniform {
        private final Util.AttributeOrUniform myUniform;
        private final Setter mySetter;

        public Uniform(GL2ES2 gl, Util.AttributeOrUniform uniform) {
            this.myUniform = uniform;
            this.mySetter = this.getSetter(gl);
        }

        private Setter getSetter(final GL2ES2 gl) {
            final int location = this.myUniform.location;
            final int size = this.myUniform.size;
            switch (this.myUniform.type) {
                case 5122: 
                case 5124: 
                case 5125: 
                case 5126: 
                case 35670: 
                case 35678: 
                case 35680: {
                    return new Setter(){

                        @Override
                        public void set(float[] values) {
                            gl.glUniform1fv(location, Math.min(size, values.length), values, 0);
                        }

                        @Override
                        public void set(float value) {
                            this.set(new float[]{value});
                        }

                        @Override
                        public void set(int[] values) {
                            gl.glUniform1iv(location, Math.min(size, values.length), values, 0);
                        }

                        @Override
                        public void set(int value) {
                            this.set(new int[]{value});
                        }
                    };
                }
                case 35664: 
                case 35667: 
                case 35671: {
                    return new Setter(){

                        @Override
                        public void set(float[] values) {
                            gl.glUniform2fv(location, Math.min(size, values.length / 2), values, 0);
                        }

                        @Override
                        public void set(float value) {
                            this.set(new float[]{value});
                        }

                        @Override
                        public void set(int[] values) {
                            gl.glUniform2iv(location, Math.min(size, values.length / 2), values, 0);
                        }

                        @Override
                        public void set(int value) {
                            this.set(new int[]{value});
                        }
                    };
                }
                case 35665: 
                case 35668: 
                case 35672: {
                    return new Setter(){

                        @Override
                        public void set(float[] values) {
                            gl.glUniform3fv(location, Math.min(size, values.length / 3), values, 0);
                        }

                        @Override
                        public void set(float value) {
                            this.set(new float[]{value});
                        }

                        @Override
                        public void set(int[] values) {
                            gl.glUniform3iv(location, Math.min(size, values.length / 3), values, 0);
                        }

                        @Override
                        public void set(int value) {
                            this.set(new int[]{value});
                        }
                    };
                }
                case 35666: 
                case 35669: 
                case 35673: {
                    return new Setter(){

                        @Override
                        public void set(float[] values) {
                            gl.glUniform4fv(location, Math.min(size, values.length / 4), values, 0);
                        }

                        @Override
                        public void set(float value) {
                            this.set(new float[]{value});
                        }

                        @Override
                        public void set(int[] values) {
                            gl.glUniform4iv(location, Math.min(size, values.length / 4), values, 0);
                        }

                        @Override
                        public void set(int value) {
                            this.set(new int[]{value});
                        }
                    };
                }
                case 35674: {
                    return new Setter(){

                        @Override
                        public void set(float[] values) {
                            gl.glUniformMatrix2fv(location, 1, false, values, 0);
                        }

                        @Override
                        public void set(float value) {
                            LOG.warn("Unexpected shader uniform value (expected mat2): " + value);
                        }

                        @Override
                        public void set(int[] values) {
                            LOG.warn("Unexpected shader uniform value (expected mat2): " + Arrays.toString(values));
                        }

                        @Override
                        public void set(int value) {
                            LOG.warn("Unexpected shader uniform value (expected mat2): " + value);
                        }
                    };
                }
                case 35675: {
                    return new Setter(){

                        @Override
                        public void set(float[] values) {
                            gl.glUniformMatrix3fv(location, 1, false, values, 0);
                        }

                        @Override
                        public void set(float value) {
                            LOG.warn("Unexpected shader uniform value (expected mat3): " + value);
                        }

                        @Override
                        public void set(int[] values) {
                            LOG.warn("Unexpected shader uniform value (expected mat3): " + Arrays.toString(values));
                        }

                        @Override
                        public void set(int value) {
                            LOG.warn("Unexpected shader uniform value (expected mat3): " + value);
                        }
                    };
                }
                case 35676: {
                    return new Setter(){

                        @Override
                        public void set(float[] values) {
                            gl.glUniformMatrix4fv(location, 1, false, values, 0);
                        }

                        @Override
                        public void set(float value) {
                            LOG.warn("Unexpected shader uniform value (expected mat4): " + value);
                        }

                        @Override
                        public void set(int[] values) {
                            LOG.warn("Unexpected shader uniform value (expected mat4): " + Arrays.toString(values));
                        }

                        @Override
                        public void set(int value) {
                            LOG.warn("Unexpected shader uniform value (expected mat4): " + value);
                        }
                    };
                }
            }
            LOG.warn("Unexpected shader uniform type: " + this.myUniform.type);
            throw new AssertionError();
        }

        public boolean set(Object value) {
            if (value instanceof Float) {
                this.mySetter.set(((Float)value).floatValue());
            } else if (value instanceof Integer) {
                this.mySetter.set((Integer)value);
            } else if (value instanceof int[]) {
                this.mySetter.set((int[])value);
            } else if (value instanceof float[]) {
                this.mySetter.set((float[])value);
            } else {
                return false;
            }
            return true;
        }

        private static interface Setter {
            public void set(int var1);

            public void set(int[] var1);

            public void set(float var1);

            public void set(float[] var1);
        }
    }

    private static class Attribute {
        private Util.AttributeOrUniform myAttribute;

        public Attribute(Util.AttributeOrUniform attribute) {
            this.myAttribute = attribute;
        }

        public void set(GL2ES2 gl, float x, float y, float z) {
            gl.glDisableVertexAttribArray(this.myAttribute.location);
            gl.glVertexAttrib3f(this.myAttribute.location, x, y, z);
        }

        public void bind(GL2ES2 gl, int elementSize, int elementType, int strideBytes, int offsetBytes) {
            gl.glEnableVertexAttribArray(this.myAttribute.location);
            gl.glVertexAttribPointer(this.myAttribute.location, elementSize, elementType, false, strideBytes, (long)offsetBytes);
        }

        public void unbind(GL2ES2 gl) {
            gl.glDisableVertexAttribArray(this.myAttribute.location);
        }
    }
}

