/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.testFramework.LightVirtualFile;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorVirtualFile
extends LightVirtualFile {
    public static final String FILENAME = "Theme Editor";
    private static final Key<ThemeEditorVirtualFile> KEY = Key.create((String)ThemeEditorVirtualFile.class.getName());
    private static final Key<Boolean> CACHE_LOOKUP_KEY = Key.create((String)"cache_lookup_key");
    private VirtualFile myParent;
    private final String myPath;

    private ThemeEditorVirtualFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile", "<init>"));
        }
        super(FILENAME);
        this.myPath = AndroidFakeFileSystem.constructPathForFile(FILENAME, project);
    }

    @NotNull
    public static ThemeEditorVirtualFile getThemeEditorFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile", "getThemeEditorFile"));
        }
        ThemeEditorVirtualFile vFile = (ThemeEditorVirtualFile)((Object)project.getUserData(KEY));
        if (vFile == null) {
            vFile = ThemeEditorVirtualFile.getThemeEditorVirtualFileFromCache(project);
            if (vFile == null) {
                vFile = new ThemeEditorVirtualFile(project);
            }
            vFile.myParent = project.getBaseDir();
            project.putUserData(KEY, (Object)vFile);
        }
        ThemeEditorVirtualFile themeEditorVirtualFile = vFile;
        if (themeEditorVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile", "getThemeEditorFile"));
        }
        return themeEditorVirtualFile;
    }

    @Nullable
    private static ThemeEditorVirtualFile getThemeEditorVirtualFileFromCache(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile", "getThemeEditorVirtualFileFromCache"));
        }
        if (project.getUserData(CACHE_LOOKUP_KEY) == null) {
            project.putUserData(CACHE_LOOKUP_KEY, (Object)true);
            String url = AndroidFakeFileSystem.INSTANCE.getProtocol() + "://" + AndroidFakeFileSystem.constructPathForFile(FILENAME, project);
            VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)project, null);
            return (ThemeEditorVirtualFile)pointer.getFile();
        }
        return null;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @NotNull
    public FileType getFileType() {
        ThemeEditorFileType themeEditorFileType = ThemeEditorFileType.INSTANCE;
        if (themeEditorFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile", "getFileType"));
        }
        return themeEditorFileType;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = AndroidFakeFileSystem.INSTANCE;
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile", "getPath"));
        }
        return string;
    }

    private static class ThemeEditorFileType
    extends FakeFileType {
        public static final ThemeEditorFileType INSTANCE = new ThemeEditorFileType();

        private ThemeEditorFileType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile$ThemeEditorFileType", "isMyFileType"));
            }
            return file.getFileType() instanceof ThemeEditorFileType;
        }

        @NotNull
        public String getName() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile$ThemeEditorFileType", "getName"));
            }
            return "";
        }

        @NotNull
        public String getDescription() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorVirtualFile$ThemeEditorFileType", "getDescription"));
            }
            return "";
        }

        public Icon getIcon() {
            return AndroidIcons.Themes;
        }
    }
}

