/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkProjects;
import com.android.tools.idea.fd.InstantRunBuilder;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.RunAsValidityService;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.DefaultGradleBuilder;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.GradleModuleTasksProvider;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    private static final Logger LOG = Logger.getInstance(MakeBeforeRunTask.class);
    public static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;

    public MakeBeforeRunTaskProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "<init>"));
        }
        this.myProject = project;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task) {
        String goal = task.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(RunConfiguration runConfiguration) {
        if (MakeBeforeRunTaskProvider.configurationTypeIsSupported(runConfiguration)) {
            MakeBeforeRunTask task = new MakeBeforeRunTask();
            if (runConfiguration instanceof AndroidRunConfigurationBase) {
                task.setEnabled(true);
            }
            return task;
        }
        return null;
    }

    private static boolean configurationTypeIsSupported(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "configurationTypeIsSupported"));
        }
        if (ApkProjects.isApkProject(runConfiguration.getProject())) {
            return false;
        }
        return runConfiguration instanceof AndroidRunConfigurationBase || MakeBeforeRunTaskProvider.isUnitTestConfiguration(runConfiguration);
    }

    private static boolean isUnitTestConfiguration(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "isUnitTestConfiguration"));
        }
        return runConfiguration instanceof JUnitConfiguration || runConfiguration.getClass().getSimpleName().equals("TestNGConfiguration");
    }

    public boolean configureTask(RunConfiguration runConfiguration, MakeBeforeRunTask task) {
        GradleEditTaskDialog dialog = new GradleEditTaskDialog(this.myProject);
        dialog.setGoal(task.getGoal());
        dialog.setAvailableGoals(this.createAvailableTasks());
        if (!dialog.showAndGet()) {
            task.setInvalid();
            return false;
        }
        task.setGoal(dialog.getGoal());
        return true;
    }

    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList gradleTasks = Lists.newArrayList();
        for (Module module : moduleManager.getModules()) {
            GradleModel gradleModel;
            AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
            if (facet == null || (gradleModel = facet.getGradleModel()) == null) continue;
            gradleTasks.addAll(gradleModel.getTaskNames());
        }
        return gradleTasks;
    }

    public boolean canExecuteTask(RunConfiguration configuration, MakeBeforeRunTask task) {
        return task.isValid();
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task) {
        String errorMsg;
        GradleSyncState syncState;
        if (!Projects.requiresAndroidModel(this.myProject) || !Projects.isDirectGradleInvocationEnabled(this.myProject)) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        final AtomicReference errorMsgRef = new AtomicReference();
        if (AndroidGradleBuildConfiguration.getInstance((Project)this.myProject).SYNC_PROJECT_BEFORE_BUILD && (syncState = GradleSyncState.getInstance(this.myProject)).isSyncNeeded() != ThreeState.NO) {
            GradleProjectImporter.getInstance().syncProjectSynchronously(this.myProject, false, new GradleSyncListener.Adapter(){

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1", "syncFailed"));
                    }
                    if (errorMessage == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1", "syncFailed"));
                    }
                    errorMsgRef.set(errorMessage);
                }
            });
        }
        if ((errorMsg = (String)errorMsgRef.get()) != null) {
            LOG.info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (configuration instanceof RunConfigurationBase && ((RunConfigurationBase)configuration).excludeCompileBeforeLaunchOption()) {
            return true;
        }
        AndroidRunConfigContext runConfigContext = (AndroidRunConfigContext)env.getCopyableUserData(AndroidRunConfigContext.KEY);
        DeviceFutures deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        List<AndroidDevice> targetDevices = deviceFutures == null ? Collections.emptyList() : deviceFutures.getDevices();
        List<String> cmdLineArgs = MakeBeforeRunTaskProvider.getCommonArguments(configuration, targetDevices);
        BeforeRunBuilder builder = MakeBeforeRunTaskProvider.createBuilder(env, MakeBeforeRunTaskProvider.getModules(this.myProject, context, configuration), configuration, runConfigContext, task.getGoal());
        try {
            boolean success = builder.build(GradleTaskRunner.newRunner(this.myProject), cmdLineArgs);
            LOG.info("Gradle invocation complete, success = " + success);
            return success;
        }
        catch (InvocationTargetException e) {
            LOG.info("Unexpected error while launching gradle before run tasks", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while launching gradle before run tasks");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @NotNull
    private static List<String> getCommonArguments(@NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getCommonArguments"));
        }
        if (targetDevices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDevices", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getCommonArguments"));
        }
        ArrayList cmdLineArgs = Lists.newArrayList();
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getDeviceSpecificArguments(targetDevices));
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getProfilingOptions(configuration));
        ArrayList arrayList = cmdLineArgs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getCommonArguments"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getDeviceSpecificArguments(@NotNull List<AndroidDevice> devices) {
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getDeviceSpecificArguments"));
        }
        if (devices.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getDeviceSpecificArguments"));
            }
            return list;
        }
        ArrayList<String> properties = new ArrayList<String>(2);
        AndroidVersion minVersion = devices.get(0).getVersion();
        for (int i = 1; i < devices.size(); ++i) {
            AndroidDevice androidDevice = devices.get(i);
            if (androidDevice.getVersion().compareTo(minVersion) >= 0) continue;
            minVersion = androidDevice.getVersion();
        }
        properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.api", (String)Integer.toString(minVersion.getFeatureLevel())));
        if (devices.size() == 1) {
            List abis;
            AndroidDevice device = devices.get(0);
            Density density = Density.getEnum((int)device.getDensity());
            if (density != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.density", (String)density.getResourceValue()));
            }
            if (!(abis = device.getAbis().stream().map(Abi::toString).collect(Collectors.toList())).isEmpty()) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.abi", (String)Joiner.on((char)',').join(abis)));
            }
        }
        ArrayList<String> arrayList = properties;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getDeviceSpecificArguments"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getProfilingOptions(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getProfilingOptions"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getProfilingOptions"));
        }
        return list;
    }

    private static BeforeRunBuilder createBuilder(@NotNull ExecutionEnvironment env, @NotNull Module[] modules, @NotNull RunConfiguration configuration, @Nullable AndroidRunConfigContext runConfigContext, @Nullable String userGoal) {
        DeviceFutures deviceFutures;
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "createBuilder"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "createBuilder"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "createBuilder"));
        }
        if (modules.length == 0) {
            throw new IllegalStateException("Unable to determine list of modules to build");
        }
        if (!StringUtil.isEmpty((String)userGoal)) {
            return new DefaultGradleBuilder(Collections.singletonList(userGoal), null);
        }
        GradleModuleTasksProvider gradleTasksProvider = new GradleModuleTasksProvider(modules);
        GradleInvoker.TestCompileType testCompileType = GradleInvoker.getTestCompileType(configuration.getType().getId());
        if (testCompileType == GradleInvoker.TestCompileType.JAVA_TESTS) {
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            return new DefaultGradleBuilder(gradleTasksProvider.getUnitTestTasks(buildMode), buildMode);
        }
        InstantRunContext irContext = (InstantRunContext)env.getCopyableUserData(InstantRunContext.KEY);
        DeviceFutures deviceFutures2 = deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        if (deviceFutures == null || irContext == null) {
            return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.ASSEMBLE, testCompileType), BuildMode.ASSEMBLE);
        }
        List<AndroidDevice> targetDevices = deviceFutures.getDevices();
        assert (targetDevices.size() == 1) : "instant run context available, but deploying to > 1 device";
        return new InstantRunBuilder(MakeBeforeRunTaskProvider.getLaunchedDevice(targetDevices.get(0)), irContext, runConfigContext, gradleTasksProvider, RunAsValidityService.getInstance());
    }

    @NotNull
    private static Module[] getModules(@NotNull Project project, @Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getModules"));
        }
        if (configuration instanceof ModuleRunProfile) {
            Module[] moduleArray = ((ModuleRunProfile)configuration).getModules();
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getModules"));
            }
            return moduleArray;
        }
        Module[] moduleArray = Projects.getModulesToBuildFromSelection(project, context);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getModules"));
        }
        return moduleArray;
    }

    @Nullable
    public static IDevice getLaunchedDevice(@NotNull AndroidDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getLaunchedDevice"));
        }
        if (!device.getLaunchedDevice().isDone()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }
}

