/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenProjectStructureHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonContextMismatchErrorHandler
extends AbstractSyncErrorHandler {
    private static final String JAVA_HOME = "javaHome=";

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String expectedAndActual;
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/DaemonContextMismatchErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/DaemonContextMismatchErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/DaemonContextMismatchErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/DaemonContextMismatchErrorHandler", "handleError"));
        }
        String firstLine = message.get(0);
        if (firstLine != null && firstLine.contains("The newly created daemon process has a different context than expected.") && message.size() > 3 && "Java home is different.".equals(message.get(2)) && StringUtil.isNotEmpty((String)(expectedAndActual = DaemonContextMismatchErrorHandler.parseExpectedAndActualJavaHomes(error.getMessage())))) {
            String newMsg = firstLine + "\n" + message.get(2) + "\n" + expectedAndActual + "\nPlease configure the JDK to match the expected one.";
            OpenProjectStructureHyperlink quickFix = OpenProjectStructureHyperlink.openJdkSettings(project);
            if (quickFix != null) {
                DaemonContextMismatchErrorHandler.updateNotification(notification, project, newMsg, quickFix);
            } else {
                DaemonContextMismatchErrorHandler.updateNotification(notification, project, newMsg, new NotificationHyperlink[0]);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @Nullable
    static String parseExpectedAndActualJavaHomes(@NotNull String errorMsg) {
        String expected;
        int endIndex;
        if (errorMsg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMsg", "com/android/tools/idea/gradle/service/notification/errors/DaemonContextMismatchErrorHandler", "parseExpectedAndActualJavaHomes"));
        }
        int startIndex = errorMsg.indexOf(JAVA_HOME);
        if (startIndex != -1 && (endIndex = errorMsg.indexOf(44, startIndex += JAVA_HOME.length())) != -1 && endIndex > startIndex && StringUtil.isNotEmpty((String)(expected = errorMsg.substring(startIndex, endIndex)))) {
            String actual = null;
            startIndex = errorMsg.indexOf(JAVA_HOME, endIndex);
            if (startIndex != -1 && (endIndex = errorMsg.indexOf(44, startIndex += JAVA_HOME.length())) != -1 && endIndex > startIndex) {
                actual = errorMsg.substring(startIndex, endIndex);
            }
            String s = String.format("Expecting: '%1$s'", expected);
            s = actual != null ? s + String.format(" but was: '%1$s'.", actual) : s + ".";
            return s;
        }
        return null;
    }
}

