/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Objects;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalMavenRepository
extends ArtifactRepository {
    @NotNull
    private final Path myRootLocation;
    @NotNull
    private final String myName;

    public LocalMavenRepository(@NotNull File rootLocation, @NotNull String name) {
        if (rootLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLocation", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository", "<init>"));
        }
        this.myRootLocation = rootLocation.toPath();
        this.myName = name;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository", "getName"));
        }
        return string;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(final @NotNull SearchRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository", "doSearch"));
        }
        final ArrayList foundArtifacts = Lists.newArrayList();
        try {
            Files.walkFileTree(this.myRootLocation, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    File parent = dir.toFile();
                    File mavenMetadataFile = new File(parent, "maven-metadata.xml");
                    if (mavenMetadataFile.isFile()) {
                        Match match = LocalMavenRepository.isMatch(mavenMetadataFile, request);
                        if (match != null) {
                            ArrayList versions = Lists.newArrayList();
                            for (File child : FileUtil.notNullize((File[])parent.listFiles())) {
                                if (!child.isDirectory()) continue;
                                String version = child.getName();
                                versions.add(GradleVersion.parse((String)version));
                            }
                            FoundArtifact artifact = new FoundArtifact(LocalMavenRepository.this.myName, match.groupId, match.artifactName, versions);
                            foundArtifacts.add(artifact);
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable e) {
            String msg = String.format("Failed to search local repository '%1$s'", this.myRootLocation);
            Logger.getInstance(LocalMavenRepository.class).warn(msg, e);
        }
        SearchResult searchResult = new SearchResult(this.myName, foundArtifacts, foundArtifacts.size());
        if (searchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository", "doSearch"));
        }
        return searchResult;
    }

    @Nullable
    private static Match isMatch(@NotNull File mavenMetadataFile, @NotNull SearchRequest request) {
        if (mavenMetadataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenMetadataFile", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository", "isMatch"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository", "isMatch"));
        }
        String groupId = request.getGroupId();
        String artifactName = request.getArtifactName();
        try {
            Document document = JDOMUtil.loadDocument((File)mavenMetadataFile);
            Element rootElement = document.getRootElement();
            if (rootElement != null) {
                Element groupIdElement = rootElement.getChild("groupId");
                if (groupId != null && groupIdElement == null) {
                    return null;
                }
                groupId = Strings.nullToEmpty((String)groupId);
                String currentGroupId = Strings.nullToEmpty((String)groupIdElement.getValue());
                if (!currentGroupId.contains(groupId)) {
                    return null;
                }
                Element artifactIdElement = rootElement.getChild("artifactId");
                if (artifactIdElement == null) {
                    return null;
                }
                String currentArtifactName = artifactIdElement.getValue();
                if (currentArtifactName.contains(artifactName)) {
                    return new Match(currentArtifactName, Strings.nullToEmpty((String)currentGroupId));
                }
            }
        }
        catch (Throwable e) {
            String msg = String.format("Failed to parse '%1$s'", mavenMetadataFile.getPath());
            Logger.getInstance(LocalMavenRepository.class).warn(msg, e);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalMavenRepository that = (LocalMavenRepository)o;
        return Objects.equals(this.myRootLocation, that.myRootLocation) && Objects.equals(this.myName, that.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myRootLocation, this.myName);
    }

    private static class Match {
        @NotNull
        final String artifactName;
        @NotNull
        final String groupId;

        Match(@NotNull String artifactName, @NotNull String groupId) {
            if (artifactName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository$Match", "<init>"));
            }
            if (groupId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/structure/model/repositories/search/LocalMavenRepository$Match", "<init>"));
            }
            this.artifactName = artifactName;
            this.groupId = groupId;
        }
    }
}

