/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.testing;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.testing.ExcludedModules;
import com.android.tools.idea.gradle.testing.ExcludedRoots;
import com.android.tools.idea.gradle.testing.FileRootSearchScope;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestArtifactSearchScopes
implements Disposable {
    private static final Key<TestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    @NotNull
    private final Module myModule;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "get"));
        }
        if (Projects.lastGradleSyncFailed(project)) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(file);
        return module != null ? TestArtifactSearchScopes.get(module) : null;
    }

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "get"));
        }
        return (TestArtifactSearchScopes)module.getUserData(SEARCH_SCOPES_KEY);
    }

    public static void initializeScopes(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "initializeScopes"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(module);
            TestArtifactSearchScopes scopes = androidModel != null ? new TestArtifactSearchScopes(module) : null;
            module.putUserData(SEARCH_SCOPES_KEY, (Object)scopes);
        }
    }

    private TestArtifactSearchScopes(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "<init>"));
        }
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getModule"));
        }
        return module;
    }

    public boolean isAndroidTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "isAndroidTestSource"));
        }
        return this.getAndroidTestSourceScope().accept(file);
    }

    public boolean isUnitTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "isUnitTestSource"));
        }
        return this.getUnitTestSourceScope().accept(file);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestSourceScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getAndroidTestSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestSourceScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getUnitTestSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getSourceScope"));
        }
        Set<File> roots = Collections.emptySet();
        AndroidGradleModel androidModel = this.getAndroidModel();
        if (androidModel != null) {
            roots = new HashSet();
            for (SourceProvider sourceProvider : androidModel.getTestSourceProviders(artifactName)) {
                roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
            }
        }
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), roots);
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getUnitTestSourceScope().exclude(this.getAndroidTestSourceScope());
            this.myAndroidTestExcludeScope = exclude.merge(this.getAndroidTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getAndroidTestExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getAndroidTestSourceScope().exclude(this.getUnitTestSourceScope());
            this.myUnitTestExcludeScope = exclude.merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getUnitTestExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getSharedTestsExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestDependencyExcludeScope().merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.mySharedTestsExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getSharedTestsExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestDependencyExcludeScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludedDependenciesScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getAndroidTestDependencyExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestDependencyExcludeScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludedDependenciesScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getUnitTestDependencyExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getExcludedDependenciesScope(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getExcludedDependenciesScope"));
        }
        AndroidGradleModel androidModel = this.getAndroidModel();
        if (androidModel == null) {
            FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), Collections.emptyList());
            if (fileRootSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getExcludedDependenciesScope"));
            }
            return fileRootSearchScope;
        }
        DependencySet mainDependencies = TestArtifactSearchScopes.extractMainDependencies(androidModel);
        DependencySet androidTestDependencies = TestArtifactSearchScopes.extractAndroidTestDependencies(androidModel);
        DependencySet unitTestDependencies = TestArtifactSearchScopes.extractUnitTestDependencies(androidModel);
        boolean isAndroidTest = "_android_test_".equals(artifactName);
        DependencySet dependenciesToInclude = isAndroidTest ? androidTestDependencies : unitTestDependencies;
        DependencySet dependenciesToExclude = isAndroidTest ? unitTestDependencies : androidTestDependencies;
        ExcludedModules excludedModules = new ExcludedModules(this.myModule);
        excludedModules.add(dependenciesToExclude);
        excludedModules.remove(dependenciesToInclude);
        excludedModules.remove(mainDependencies);
        ExcludedRoots excludedRoots = new ExcludedRoots(this.myModule, excludedModules, dependenciesToExclude, dependenciesToInclude, isAndroidTest);
        excludedRoots.removeLibraryPaths(mainDependencies);
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), excludedRoots.get());
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getExcludedDependenciesScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    private static DependencySet extractUnitTestDependencies(@NotNull AndroidGradleModel androidModel) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "extractUnitTestDependencies"));
        }
        JavaArtifact artifact = androidModel.getUnitTestArtifactInSelectedVariant();
        DependencySet dependencySet = TestArtifactSearchScopes.extractTestDependencies((BaseArtifact)artifact, androidModel.getModelVersion());
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "extractUnitTestDependencies"));
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractAndroidTestDependencies(@NotNull AndroidGradleModel androidModel) {
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "extractAndroidTestDependencies"));
        }
        AndroidArtifact artifact = androidModel.getAndroidTestArtifactInSelectedVariant();
        DependencySet dependencySet = TestArtifactSearchScopes.extractTestDependencies((BaseArtifact)artifact, androidModel.getModelVersion());
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "extractAndroidTestDependencies"));
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractTestDependencies(@Nullable BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        DependencySet dependencySet = TestArtifactSearchScopes.extractDependencies(DependencyScope.TEST, artifact, modelVersion);
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "extractTestDependencies"));
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractMainDependencies(AndroidGradleModel androidModel) {
        DependencySet dependencySet = TestArtifactSearchScopes.extractDependencies(DependencyScope.COMPILE, (BaseArtifact)androidModel.getMainArtifact(), androidModel.getModelVersion());
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "extractMainDependencies"));
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractDependencies(@NotNull DependencyScope scope, @Nullable BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "extractDependencies"));
        }
        DependencySet dependencySet = artifact != null ? Dependency.extractFrom(artifact, scope, modelVersion) : DependencySet.EMPTY;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "extractDependencies"));
        }
        return dependencySet;
    }

    @Nullable
    private AndroidGradleModel getAndroidModel() {
        return this.myModule.isDisposed() ? null : AndroidGradleModel.get(this.myModule);
    }

    public void dispose() {
        this.myModule.putUserData(SEARCH_SCOPES_KEY, null);
    }
}

