/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatMessageParser;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.StackTraceExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidLogcatReceiver
extends AndroidOutputReceiver
implements Disposable {
    private final LogCatMessageParser myParser;
    private static final String STACK_TRACE_LINE_PREFIX = StringUtil.repeatSymbol((char)' ', (int)4);
    private static final String STACK_TRACE_CAUSE_LINE_PREFIX = Character.toString(' ');
    private volatile boolean myCanceled;
    private final AndroidLogcatService.LogLineListener myLogLineListener;
    private final IDevice myDevice;
    private int myDelayedNewlineCount;
    private final StackTraceExpander myStackTraceExpander;
    @Nullable
    private LogCatHeader myActiveHeader;
    private int myLineIndex;

    public AndroidLogcatReceiver(@NotNull IDevice device, @NotNull AndroidLogcatService.LogLineListener logLineListener) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "<init>"));
        }
        if (logLineListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logLineListener", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "<init>"));
        }
        this.myParser = new LogCatMessageParser();
        this.myCanceled = false;
        this.myDevice = device;
        this.myLogLineListener = logLineListener;
        this.myStackTraceExpander = new StackTraceExpander(STACK_TRACE_LINE_PREFIX, STACK_TRACE_CAUSE_LINE_PREFIX);
    }

    @Override
    public void processNewLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "processNewLine"));
        }
        if ((line = line.replaceAll("\\r", "")).isEmpty()) {
            ++this.myDelayedNewlineCount;
            return;
        }
        LogCatHeader header = this.myParser.processLogHeader(line, this.myDevice);
        if (header != null) {
            this.myStackTraceExpander.reset();
            this.myActiveHeader = header;
            this.myLineIndex = 0;
            this.myDelayedNewlineCount = 0;
        } else if (this.myActiveHeader != null) {
            if (this.myDelayedNewlineCount > 0 && this.myLineIndex == 0) {
                this.myDelayedNewlineCount = 0;
            } else {
                this.processAnyDelayedNewlines(this.myActiveHeader);
            }
            for (String processedLine : this.myStackTraceExpander.process(line)) {
                this.notifyLine(this.myActiveHeader, processedLine);
            }
        }
    }

    void notifyLine(@NotNull LogCatHeader header, @NotNull String line) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "notifyLine"));
        }
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "notifyLine"));
        }
        this.myLogLineListener.receiveLogLine(new LogCatMessage(header, line));
        ++this.myLineIndex;
    }

    private void processAnyDelayedNewlines(@NotNull LogCatHeader header) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "processAnyDelayedNewlines"));
        }
        if (this.myDelayedNewlineCount == 0) {
            return;
        }
        for (int i = 0; i < this.myDelayedNewlineCount; ++i) {
            this.notifyLine(header, "");
        }
        this.myDelayedNewlineCount = 0;
    }

    public boolean isCancelled() {
        return this.myCanceled;
    }

    public void dispose() {
        this.cancel();
    }

    public void cancel() {
        this.myCanceled = true;
    }
}

