/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import icons.AndroidIcons;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FormFactor {
    MOBILE("Mobile", "Phone and Tablet", 15, 9, 25, Lists.newArrayList((Object[])new Integer[]{20}), Lists.newArrayList((Object[])new IdDisplay[]{SystemImage.DEFAULT_TAG, SystemImage.GOOGLE_APIS_TAG, SystemImage.GOOGLE_APIS_X86_TAG}), null, AndroidIcons.FormFactors.Mobile_64, AndroidIcons.FormFactors.Mobile_128),
    WEAR("Wear", "Wear", 21, 20, 23, null, Lists.newArrayList((Object[])new IdDisplay[]{SystemImage.WEAR_TAG}), null, AndroidIcons.FormFactors.Wear_64, AndroidIcons.FormFactors.Wear_128),
    TV("TV", "TV", 21, 21, 24, null, Lists.newArrayList((Object[])new IdDisplay[]{SystemImage.TV_TAG}), null, AndroidIcons.FormFactors.Tv_64, AndroidIcons.FormFactors.Tv_128),
    CAR("Car", "Android Auto", 21, 21, 21, null, null, MOBILE, AndroidIcons.FormFactors.Car_64, AndroidIcons.FormFactors.Car_128),
    GLASS("Glass", "Glass", 19, -1, -1, null, Lists.newArrayList((Object[])new IdDisplay[]{SystemImage.GLASS_TAG}), null, AndroidIcons.FormFactors.Glass_64, AndroidIcons.FormFactors.Glass_128);

    private static final Map<String, FormFactor> myFormFactors;
    public final String id;
    @Nullable
    private String myDisplayName;
    public final int defaultApi;
    @NotNull
    private final List<Integer> myApiBlacklist;
    @NotNull
    private final List<IdDisplay> myTags;
    private final int myMinOfflineApiLevel;
    private final int myMaxOfflineApiLevel;
    @Nullable
    public final FormFactor baseFormFactor;
    @NotNull
    private final Icon myIcon64;
    @NotNull
    private final Icon myIcon128;

    private FormFactor(String id, String displayName, int defaultApi, @Nullable int minOfflineApiLevel, @Nullable int maxOfflineApiLevel, @Nullable List<Integer> apiBlacklist, @NotNull List<IdDisplay> apiTags, @NotNull FormFactor baseFormFactor, Icon icon64, Icon icon128) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/npw/FormFactor", "<init>"));
        }
        if (icon64 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon64", "com/android/tools/idea/npw/FormFactor", "<init>"));
        }
        if (icon128 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon128", "com/android/tools/idea/npw/FormFactor", "<init>"));
        }
        this.id = id;
        this.myDisplayName = displayName;
        this.defaultApi = defaultApi;
        this.myMinOfflineApiLevel = minOfflineApiLevel;
        this.myIcon64 = icon64;
        this.myIcon128 = icon128;
        this.myMaxOfflineApiLevel = Math.min(maxOfflineApiLevel, 24);
        this.myApiBlacklist = apiBlacklist != null ? apiBlacklist : Collections.emptyList();
        this.myTags = apiTags != null ? apiTags : Collections.emptyList();
        this.baseFormFactor = baseFormFactor;
    }

    @NotNull
    public static FormFactor get(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/npw/FormFactor", "get"));
        }
        FormFactor result = myFormFactors.get(id);
        FormFactor formFactor = result == null ? MOBILE : result;
        if (formFactor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactor", "get"));
        }
        return formFactor;
    }

    @NotNull
    public static FormFactor getFormFactor(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/npw/FormFactor", "getFormFactor"));
        }
        if (HardwareConfigHelper.isWear((Device)device)) {
            FormFactor formFactor = WEAR;
            if (formFactor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactor", "getFormFactor"));
            }
            return formFactor;
        }
        if (HardwareConfigHelper.isTv((Device)device)) {
            FormFactor formFactor = TV;
            if (formFactor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactor", "getFormFactor"));
            }
            return formFactor;
        }
        FormFactor formFactor = MOBILE;
        if (formFactor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactor", "getFormFactor"));
        }
        return formFactor;
    }

    public String toString() {
        return this.myDisplayName == null ? this.id : this.myDisplayName;
    }

    @NotNull
    List<Integer> getApiBlacklist() {
        List<Integer> list = this.myApiBlacklist;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactor", "getApiBlacklist"));
        }
        return list;
    }

    @NotNull
    List<IdDisplay> getTags() {
        List<IdDisplay> list = this.myTags;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactor", "getTags"));
        }
        return list;
    }

    public int getMinOfflineApiLevel() {
        return this.myMinOfflineApiLevel;
    }

    public int getMaxOfflineApiLevel() {
        return this.myMaxOfflineApiLevel;
    }

    public static Iterator<FormFactor> iterator() {
        return myFormFactors.values().iterator();
    }

    @NotNull
    public Icon getLargeIcon() {
        Icon icon = this.myIcon128;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactor", "getLargeIcon"));
        }
        return icon;
    }

    public boolean hasEmulator() {
        return this != GLASS;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon64;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactor", "getIcon"));
        }
        return icon;
    }

    static {
        myFormFactors = new ImmutableMap.Builder().put((Object)FormFactor.MOBILE.id, (Object)MOBILE).put((Object)FormFactor.WEAR.id, (Object)WEAR).put((Object)FormFactor.TV.id, (Object)TV).put((Object)FormFactor.CAR.id, (Object)CAR).put((Object)FormFactor.GLASS.id, (Object)GLASS).build();
    }
}

