/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.res.AppResourceRepository;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class AssetStudioUtils {
    @NotNull
    public static BufferedImage createDummyImage() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "createDummyImage"));
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage trim(@NotNull BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "trim"));
        }
        BufferedImage cropped = ImageUtils.cropBlank(image, null, 2);
        BufferedImage bufferedImage = cropped != null ? cropped : image;
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "trim"));
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage pad(@NotNull BufferedImage image, int paddingPercent) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "pad"));
        }
        if (image.getWidth() <= 1 || image.getHeight() <= 1) {
            BufferedImage bufferedImage = image;
            if (bufferedImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "pad"));
            }
            return bufferedImage;
        }
        if (paddingPercent > 100) {
            paddingPercent = 100;
        }
        int largerSide = Math.max(image.getWidth(), image.getHeight());
        int smallerSide = Math.min(image.getWidth(), image.getHeight());
        int padding = largerSide * paddingPercent / 100;
        padding = Math.max(-(smallerSide / 2 - 1), padding);
        BufferedImage bufferedImage = AssetUtil.paddedImage((BufferedImage)image, (int)padding);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "pad"));
        }
        return bufferedImage;
    }

    public static boolean resourceExists(@NotNull AndroidProjectPaths paths, @NotNull ResourceFolderType resourceType, @NotNull String name) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        File resDir = paths.getResDirectory();
        if (resDir == null) {
            return false;
        }
        File[] resTypes = resDir.listFiles();
        if (resTypes == null) {
            return false;
        }
        for (File resTypeDir : resTypes) {
            File[] files;
            if (!resTypeDir.isDirectory() || !resourceType.equals((Object)ResourceFolderType.getFolderType((String)resTypeDir.getName())) || (files = resTypeDir.listFiles()) == null) continue;
            for (File f : files) {
                if (!FileUtil.getNameWithoutExtension((File)f).equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean resourceExists(@NotNull AndroidFacet facet, @NotNull ResourceType resourceType, @NotNull String name) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        AppResourceRepository repository = facet.getAppResources(true);
        return repository.hasResourceItem(resourceType, name);
    }

    private AssetStudioUtils() {
    }
}

