/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.ide.common.vectordrawable.VdIcon;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class IconPickerDialog
extends DialogWrapper {
    private static final String DEFAULT_ICON_NAME = "action/ic_android_black_24dp.xml";
    private static final String[] ICON_CATEGORIES = new String[]{"All", "Action", "Alert", "Av", "Communication", "Content", "Device", "Editor", "File", "Hardware", "Image", "Maps", "Navigation", "Notification", "Social", "Toggle"};
    private static final String ALL_CATEGORY = ICON_CATEGORIES[0];
    private static final int COLUMN_NUMBER = 6;
    private static final int ICON_ROW_HEIGHT = 48;
    public static final Color DARCULA_ICON_BACKGROUND = new Color(0x5D5D5D);
    private final Multimap<String, VdIcon> myCategoryIcons;
    private final List<VdIcon> myIconList;
    private final AbstractTableModel myModel;
    private final JBTable myIconTable;
    private JPanel myContentPanel;
    private JPanel myCategoriesPanel;
    private JPanel myIconsPanel;
    private JPanel myLicensePanel;
    private HyperlinkLabel myLicenseLabel;
    private VdIcon mySelectedIcon;

    public IconPickerDialog(VdIcon selectedIcon) {
        super(false);
        this.$$$setupUI$$$();
        this.myCategoryIcons = TreeMultimap.create();
        this.myIconList = new ArrayList<VdIcon>();
        this.myModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return VdIcon.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                int index = rowIndex * 6 + columnIndex;
                if (index < 0) {
                    return null;
                }
                return IconPickerDialog.this.myIconList.size() > index ? IconPickerDialog.this.myIconList.get(index) : null;
            }

            @Override
            public int getRowCount() {
                return IconPickerDialog.this.myIconList.size() / 6 + (IconPickerDialog.this.myIconList.size() % 6 == 0 ? 0 : 1);
            }

            @Override
            public int getColumnCount() {
                return 6;
            }
        };
        this.myIconTable = new JBTable((TableModel)this.myModel);
        this.mySelectedIcon = null;
        this.setTitle("Select Icon");
        this.initializeIconMap();
        JBList categoryList = new JBList((Object[])ICON_CATEGORIES);
        JBScrollPane categoryPane = new JBScrollPane((Component)categoryList);
        this.myCategoriesPanel.add((Component)categoryPane);
        Color iconBackgroundColor = UIUtil.isUnderDarcula() ? DARCULA_ICON_BACKGROUND : UIUtil.getListBackground();
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                VdIcon icon = (VdIcon)value;
                this.setText("");
                this.setToolTipText(icon != null ? icon.getName() : null);
                this.setIcon((Icon)icon);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table.getValueAt(row, column) == null) {
                    Component cell = super.getTableCellRendererComponent(table, value, false, false, row, column);
                    cell.setFocusable(false);
                    return cell;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        };
        this.myIconTable.setBackground(iconBackgroundColor);
        this.myIconTable.setDefaultRenderer(VdIcon.class, (TableCellRenderer)tableRenderer);
        this.myIconTable.setRowHeight(48);
        this.myIconTable.setSelectionMode(0);
        this.myIconTable.setCellSelectionEnabled(true);
        this.myIconsPanel.add((Component)new JBScrollPane((Component)this.myIconTable));
        this.myLicenseLabel.setHyperlinkText("These icons are available under the ", "CC-BY license", "");
        this.myLicenseLabel.setHyperlinkTarget("https://creativecommons.org/licenses/by/4.0/");
        ListSelectionModel selModel = this.myIconTable.getSelectionModel();
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.myIconTable.setGridColor(iconBackgroundColor);
        this.myIconTable.setIntercellSpacing(new Dimension(0, 0));
        this.myIconTable.setRowMargin(0);
        ListSelectionListener listener = e -> {
            VdIcon icon;
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = this.myIconTable.getSelectedRow();
            int col = this.myIconTable.getSelectedColumn();
            this.mySelectedIcon = icon = (VdIcon)this.myModel.getValueAt(row, col);
            this.setOKActionEnabled(icon != null);
        };
        selModel.addListSelectionListener(listener);
        ListSelectionModel colSelModel = this.myIconTable.getColumnModel().getSelectionModel();
        colSelModel.addListSelectionListener(listener);
        categoryList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateIconList((String)categoryList.getSelectedValue());
        });
        categoryList.setSelectedIndex(0);
        selModel.setSelectionMode(0);
        selModel.setSelectionInterval(0, 0);
        this.myIconTable.setColumnSelectionInterval(0, 0);
        this.myIconTable.requestFocusInWindow();
        if (selectedIcon != null) {
            this.initializeSelection(selectedIcon);
        }
        this.init();
    }

    @NotNull
    public static VdIcon getDefaultIcon() {
        URL url = GraphicGenerator.class.getClassLoader().getResource("images/material_design_icons/action/ic_android_black_24dp.xml");
        VdIcon vdIcon = new VdIcon(url);
        if (vdIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog", "getDefaultIcon"));
        }
        return vdIcon;
    }

    private void initializeSelection(@NotNull VdIcon selectedIcon) {
        if (selectedIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedIcon", "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog", "initializeSelection"));
        }
        for (int r = 0; r < this.myIconTable.getRowCount(); ++r) {
            for (int c = 0; c < this.myIconTable.getColumnCount(); ++c) {
                VdIcon icon = (VdIcon)this.myIconTable.getValueAt(r, c);
                if (!icon.getURL().equals(selectedIcon.getURL())) continue;
                this.myIconTable.changeSelection(r, c, false, false);
                return;
            }
        }
    }

    private void initializeIconMap() {
        for (int i = 1; i < ICON_CATEGORIES.length; ++i) {
            String categoryName = ICON_CATEGORIES[i];
            String categoryNameLowerCase = categoryName.toLowerCase(Locale.ENGLISH);
            String fullDirName = "images/material_design_icons/" + categoryNameLowerCase + '/';
            Iterator iterator = GraphicGenerator.getResourcesNames((String)fullDirName, (String)".xml");
            while (iterator.hasNext()) {
                String iconName = (String)iterator.next();
                URL url = GraphicGenerator.class.getClassLoader().getResource(fullDirName + iconName);
                VdIcon icon = new VdIcon(url);
                this.myCategoryIcons.put((Object)categoryName, (Object)icon);
            }
        }
        this.myCategoryIcons.putAll((Object)ALL_CATEGORY, (Iterable)this.myCategoryIcons.values());
    }

    public VdIcon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    private void updateIconList(@NotNull String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryName", "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog", "updateIconList"));
        }
        this.myIconList.clear();
        assert (this.myCategoryIcons.containsKey((Object)categoryName));
        this.myIconList.addAll(this.myCategoryIcons.get((Object)categoryName));
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.myModel.fireTableDataChanged();
        this.myIconTable.setColumnSelectionInterval(0, 0);
        this.myIconTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myContentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(20, 20));
        this.myCategoriesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, "West");
        this.myIconsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "Center");
        this.myLicensePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, "South");
        this.myLicenseLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

