/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.deprecated;

import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.ModuleTemplateProvider;
import com.android.tools.idea.ui.ASGallery;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChooseModuleTypeStep
extends DynamicWizardStepWithDescription {
    private final Iterable<ModuleTemplateProvider> myModuleTypesProviders;
    private JPanel myPanel;
    private ASGallery<ModuleTemplate> myFormFactorGallery;

    public ChooseModuleTypeStep(Iterable<ModuleTemplateProvider> moduleTypesProviders, @Nullable Disposable parentDisposable) {
        super(parentDisposable);
        this.myModuleTypesProviders = moduleTypesProviders;
        this.myPanel = this.createGallery();
        this.setBodyComponent(this.myPanel);
    }

    private JPanel createGallery() {
        Dimension thumbnailSize = WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE;
        this.myFormFactorGallery = new ASGallery<ModuleTemplate>((ListModel)JBList.createDefaultListModel((Object[])new Object[0]), (Function)new Function<ModuleTemplate, Image>(){

            public Image apply(ModuleTemplate input) {
                return IconUtil.toImage((Icon)input.getIcon());
            }
        }, (Function)new Function<ModuleTemplate, String>(){

            public String apply(@Nullable ModuleTemplate input) {
                return input == null ? "<none>" : input.getName();
            }
        }, thumbnailSize, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicWizard wizard = ChooseModuleTypeStep.this.getWizard();
                assert (wizard != null);
                ChooseModuleTypeStep.this.getWizard().doNextAction();
            }
        }){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension preferred = this.getPreferredSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                return new Dimension(preferred.width, (int)((double)this.computeCellSize().height * 2.2) + heightInsets);
            }
        };
        this.myFormFactorGallery.setMinimumSize(new Dimension(thumbnailSize.width * 2 + 1, thumbnailSize.height));
        this.myFormFactorGallery.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        AccessibleContext accessibleContext = this.myFormFactorGallery.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(this.getStepTitle());
        }
        JPanel panel = new JPanel((LayoutManager)new JBCardLayout());
        panel.add("only card", (Component)new JBScrollPane(this.myFormFactorGallery));
        return panel;
    }

    @Override
    public void init() {
        super.init();
        ImmutableList.Builder deviceTemplates = ImmutableList.builder();
        ImmutableList.Builder extrasTemplates = ImmutableList.builder();
        HashSet formFactorSet = Sets.newHashSet();
        for (ModuleTemplateProvider provider : this.myModuleTypesProviders) {
            for (ModuleTemplate moduleTemplate : provider.getModuleTemplates()) {
                FormFactor formFactor = moduleTemplate.getFormFactor();
                if (formFactor != null) {
                    if (formFactor == FormFactor.CAR) continue;
                    deviceTemplates.add((Object)moduleTemplate);
                    formFactorSet.add(formFactor);
                    continue;
                }
                extrasTemplates.add((Object)moduleTemplate);
            }
        }
        for (final FormFactor formFactor : formFactorSet) {
            this.registerValueDeriver(FormFactorUtils.getInclusionKey(formFactor), new ScopedDataBinder.ValueDeriver<Boolean>(){

                @Override
                @Nullable
                public Boolean deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable Boolean currentValue) {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/deprecated/ChooseModuleTypeStep$5", "deriveValue"));
                    }
                    ModuleTemplate moduleTemplate = ChooseModuleTypeStep.this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
                    return moduleTemplate != null && Objects.equal((Object)((Object)formFactor), (Object)((Object)moduleTemplate.getFormFactor()));
                }
            });
        }
        ImmutableList galleryTemplatesList = deviceTemplates.build();
        ImmutableList extrasTemplatesList = extrasTemplates.build();
        Iterable allTemplates = Iterables.concat((Iterable)galleryTemplatesList, (Iterable)extrasTemplatesList);
        this.myFormFactorGallery.setModel(JBList.createDefaultListModel((Object[])Iterables.toArray((Iterable)allTemplates, ModuleTemplate.class)));
        ModuleTypeBinding binding = new ModuleTypeBinding();
        this.register(WizardConstants.SELECTED_MODULE_TYPE_KEY, this.myPanel, binding);
        this.myFormFactorGallery.addListSelectionListener(new ModuleTypeSelectionListener());
        if (!galleryTemplatesList.isEmpty()) {
            this.myState.put(WizardConstants.SELECTED_MODULE_TYPE_KEY, galleryTemplatesList.get(0));
        }
    }

    @Override
    public boolean commitStep() {
        ModuleTemplate selected = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        if (selected != null) {
            selected.updateWizardState(this.myState);
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Choose Module Type Step" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/deprecated/ChooseModuleTypeStep", "getStepName"));
        }
        return "Choose Module Type Step";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("New Module" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/deprecated/ChooseModuleTypeStep", "getStepTitle"));
        }
        return "New Module";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return "Android Studio";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFormFactorGallery;
    }

    private class ModuleTypeSelectionListener
    implements ListSelectionListener {
        private ModuleTypeSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ModuleTemplate moduleTemplate = (ModuleTemplate)ChooseModuleTypeStep.this.myFormFactorGallery.getSelectedElement();
            if (moduleTemplate != null) {
                ChooseModuleTypeStep.this.myState.put(KEY_DESCRIPTION, moduleTemplate.getDescription());
            }
            ChooseModuleTypeStep.this.saveState(ChooseModuleTypeStep.this.myPanel);
            ChooseModuleTypeStep.this.invokeUpdate(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        }
    }

    private class ModuleTypeBinding
    extends ScopedDataBinder.ComponentBinding<ModuleTemplate, JPanel> {
        private ModuleTypeBinding() {
        }

        @Override
        public void setValue(@Nullable ModuleTemplate newValue, @NotNull JPanel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/deprecated/ChooseModuleTypeStep$ModuleTypeBinding", "setValue"));
            }
            ChooseModuleTypeStep.this.myFormFactorGallery.setSelectedElement(newValue);
        }

        @Override
        @Nullable
        public ModuleTemplate getValue(@NotNull JPanel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/deprecated/ChooseModuleTypeStep$ModuleTypeBinding", "getValue"));
            }
            return (ModuleTemplate)ChooseModuleTypeStep.this.myFormFactorGallery.getSelectedElement();
        }
    }
}

