/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.ideahost;

import com.android.tools.idea.npw.ideahost.IdeaWizardAdapter;
import com.android.tools.idea.npw.project.ConfigureAndroidProjectStep;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Preconditions;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ModifiableRootModel;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidModuleBuilder
extends ModuleBuilder
implements WizardDelegate {
    private static final String MODULE_NAME = "Android";
    private static final String MODULE_DESCRIPTION = "Android modules are used for developing apps to run on the <b>Android</b> operating system. An <b>Android</b> module consists of one or more <b>Activities</b> and may support a number of form-factors including <b>Phone and Tablet</b>, <b>Wear</b> and <b>Android Auto</b>.";
    @Nullable(value="No adapter has been instantiated")
    private IdeaWizardAdapter myWizardAdapter;

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        if (Boolean.getBoolean("use.npw.modelwizard")) {
            return "Android (New)";
        }
        return MODULE_NAME;
    }

    public String getDescription() {
        return MODULE_DESCRIPTION;
    }

    public Icon getNodeIcon() {
        return AndroidIcons.Android;
    }

    public String getParentGroup() {
        return "Java";
    }

    @NotNull
    public ModuleType getModuleType() {
        ModuleType moduleType = JavaModuleType.getModuleType();
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ideahost/AndroidModuleBuilder", "getModuleType"));
        }
        return moduleType;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/android/tools/idea/npw/ideahost/AndroidModuleBuilder", "modifyProjectTypeStep"));
        }
        return null;
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        if (!Boolean.getBoolean("use.npw.modelwizard")) {
            return null;
        }
        if (this.myWizardAdapter == null) {
            this.createWizardAdaptor(context.getWizard(), context.isCreatingNewProject() ? WizardType.PROJECT : WizardType.MODULE);
        }
        assert (this.myWizardAdapter != null);
        return this.myWizardAdapter.getProxyStep();
    }

    public void doNextAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doNextAction();
    }

    public void doPreviousAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doPreviousAction();
    }

    public void doFinishAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doFinishAction();
    }

    public boolean canProceed() {
        return this.myWizardAdapter == null || this.myWizardAdapter.canProceed();
    }

    private void createWizardAdaptor(@NotNull AbstractWizard hostWizard, @NotNull WizardType type) {
        if (hostWizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostWizard", "com/android/tools/idea/npw/ideahost/AndroidModuleBuilder", "createWizardAdaptor"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/npw/ideahost/AndroidModuleBuilder", "createWizardAdaptor"));
        }
        Preconditions.checkState((this.myWizardAdapter == null ? 1 : 0) != 0, (Object)"Attempting to create a Wizard Adaptor when one already exists.");
        ModelWizard.Builder builder = new ModelWizard.Builder(new ModelWizardStep[0]);
        if (type != WizardType.PROJECT) {
            throw new UnsupportedOperationException();
        }
        NewProjectModel projectModel = new NewProjectModel();
        builder.addStep(new ConfigureAndroidProjectStep(projectModel));
        this.myWizardAdapter = new IdeaWizardAdapter(hostWizard, builder.build());
    }

    private static enum WizardType {
        PROJECT,
        MODULE;

    }
}

