/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.RenderTask;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MenuPreviewRenderer
extends LayoutPullParserFactory {
    private static final String ATTR_ORDER_IN_CATEGORY = "orderInCategory";
    private static final String ATTR_MENU_CATEGORY = "menuCategory";
    private static final String ATTR_CHECKABLE = "checkable";
    private static final String ATTR_ALPHABETIC_SHORTCUT = "alphabeticShortcut";
    private static final String ATTR_DUPLICATE_PARENT_STATE = "duplicateParentState";
    private static final String ATTR_NUMERIC_SHORTCUT = "numericShortcut";
    private static final String ATTR_CHECKABLE_BEHAVIOR = "checkableBehavior";
    private static final String ATTR_FOCUSABLE = "focusable";
    private static final String ATTR_CLICKABLE = "clickable";
    private static final String ATTR_ELLIPSIZE = "ellipsize";
    private static final String ATTR_FADING_EDGE = "fadingEdge";
    public static final String ATTR_TEXT_COLOR = "textColor";
    public static final String ATTR_TEXT_ALIGNMENT = "textAlignment";
    public static final String ATTR_TEXT_APPEARANCE = "textAppearance";
    private static final String VALUE_MARQUEE = "marquee";
    private static final String VALUE_SINGLE = "single";
    private static final String VALUE_ALL = "all";
    private static final String VALUE_WITH_TEXT = "withText";
    private static final String VALUE_NEVER = "never";
    private final ResourceResolver myResolver;
    private final Document myDocument;
    private final Module myModule;
    private final int myApiLevel;
    private final Map<Element, Object> viewCookies = Maps.newHashMap();
    private boolean myThemeIsLight;
    private final XmlTag myRootTag;
    private static final int CHECKABLE_NONE = 0;
    private static final int CHECKABLE_ALL = 1;
    private static final int CHECKABLE_EXCLUSIVE = 2;
    private int myGroupCategory;
    private int myGroupOrder;
    private int myGroupCheckable;
    private boolean myGroupVisible = true;
    private boolean myGroupEnabled = true;
    private static final int[] ourCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
    private static final int USER_MASK = 65535;
    private static final int CATEGORY_MASK = -65536;
    private static final int CATEGORY_SHIFT = 16;

    public MenuPreviewRenderer(RenderTask renderTask, XmlFile file) {
        this.myRootTag = file.getRootTag();
        this.myResolver = renderTask.getResourceResolver();
        assert (this.myResolver != null);
        this.myDocument = DomPullParser.createEmptyPlainDocument();
        assert (this.myDocument != null);
        this.myModule = renderTask.getModule();
        Configuration configuration = renderTask.getConfiguration();
        IAndroidTarget target = configuration.getTarget();
        this.myApiLevel = target != null ? target.getVersion().getApiLevel() : 1;
        this.myThemeIsLight = MenuPreviewRenderer.isLightTheme(this.myResolver);
    }

    private static boolean isLightTheme(ResourceResolver resolver) {
        String current = (resolver.isProjectTheme() ? "@style/" : "@android:style/") + resolver.getThemeName();
        return resolver.themeExtends("@android:style/Theme.Light", current);
    }

    public ILayoutPullParser render() {
        if (this.myRootTag == null) {
            return MenuPreviewRenderer.createEmptyParser();
        }
        Element root = MenuPreviewRenderer.addRootElement(this.myDocument, "LinearLayout");
        MenuPreviewRenderer.setAndroidAttr(root, "layout_width", "fill_parent");
        MenuPreviewRenderer.setAndroidAttr(root, "layout_height", "fill_parent");
        MenuPreviewRenderer.setAndroidAttr(root, "orientation", "vertical");
        boolean createdActionBar = false;
        if (this.myApiLevel >= 11) {
            createdActionBar = this.addActionBar(root);
        }
        Element popup = this.createMenuPopup();
        if (createdActionBar) {
            MenuPreviewRenderer.setAndroidAttr(popup, "layout_marginTop", "-10dp");
        }
        root.appendChild(popup);
        this.populateMenu(popup);
        MenuPreviewRenderer.addFidelityWarning(this.myDocument, root, "Menu");
        return new DomPullParser(this.myDocument.getDocumentElement()).setViewCookies(this.viewCookies);
    }

    private Element createActionBar() {
        Element layout = this.myDocument.createElement("LinearLayout");
        MenuPreviewRenderer.setAndroidAttr(layout, "layout_width", "fill_parent");
        MenuPreviewRenderer.setAndroidAttr(layout, "layout_height", "wrap_content");
        MenuPreviewRenderer.setAndroidAttr(layout, "layout_gravity", "right");
        MenuPreviewRenderer.setAndroidAttr(layout, "orientation", "horizontal");
        MenuPreviewRenderer.setAndroidAttr(layout, "gravity", "center_vertical|right");
        if (this.myApiLevel >= 11 && this.myResolver.getFrameworkResource(ResourceType.DRAWABLE, "action_bar_background") != null) {
            MenuPreviewRenderer.setAndroidAttr(layout, "background", "@android:drawable/action_bar_background");
        } else {
            MenuPreviewRenderer.setAndroidAttr(layout, "background", "#ff85878a");
        }
        if (this.myApiLevel >= 11 && this.myResolver.getFrameworkResource(ResourceType.ATTR, "actionBarSize") != null) {
            MenuPreviewRenderer.setAndroidAttr(layout, "layout_height", "?android:attr/actionBarSize");
        } else if (this.myResolver.getProjectResource(ResourceType.ATTR, "actionBarSize") != null) {
            MenuPreviewRenderer.setAndroidAttr(layout, "layout_height", "?attr/actionBarSize");
        } else {
            MenuPreviewRenderer.setAndroidAttr(layout, "layout_height", "48dp");
        }
        MergedManifest manifestInfo = MergedManifest.get(this.myModule);
        String applicationIcon = manifestInfo.getApplicationIcon();
        if (applicationIcon != null) {
            Element imageView = this.myDocument.createElement("ImageView");
            layout.appendChild(imageView);
            MenuPreviewRenderer.setAndroidAttr(imageView, "layout_width", "wrap_content");
            MenuPreviewRenderer.setAndroidAttr(imageView, "layout_height", "wrap_content");
            MenuPreviewRenderer.setAndroidAttr(imageView, "src", applicationIcon);
            MenuPreviewRenderer.setAndroidAttr(imageView, "scaleX", "0.9");
            MenuPreviewRenderer.setAndroidAttr(imageView, "scaleY", "0.9");
            Element dummy = this.myDocument.createElement("View");
            layout.appendChild(dummy);
            MenuPreviewRenderer.setAndroidAttr(dummy, "layout_weight", "1");
            MenuPreviewRenderer.setAndroidAttr(dummy, "layout_width", "wrap_content");
            MenuPreviewRenderer.setAndroidAttr(dummy, "layout_height", "wrap_content");
        }
        return layout;
    }

    private Element createMenuPopup() {
        Element layout = this.myDocument.createElement("LinearLayout");
        MenuPreviewRenderer.setAndroidAttr(layout, "layout_width", "wrap_content");
        MenuPreviewRenderer.setAndroidAttr(layout, "layout_height", "wrap_content");
        MenuPreviewRenderer.setAndroidAttr(layout, "layout_gravity", "right");
        MenuPreviewRenderer.setAndroidAttr(layout, "orientation", "vertical");
        if (this.myThemeIsLight) {
            if (this.myApiLevel >= 11 && this.myResolver.getFrameworkResource(ResourceType.DRAWABLE, "menu_panel_holo_light") != null) {
                MenuPreviewRenderer.setAndroidAttr(layout, "background", "@android:drawable/menu_panel_holo_light");
            } else {
                MenuPreviewRenderer.setAndroidAttr(layout, "background", "@android:drawable/popup_full_bright");
            }
        } else if (this.myApiLevel >= 11 && this.myResolver.getFrameworkResource(ResourceType.DRAWABLE, "menu_panel_holo_dark") != null) {
            MenuPreviewRenderer.setAndroidAttr(layout, "background", "@android:drawable/menu_panel_holo_dark");
        } else {
            MenuPreviewRenderer.setAndroidAttr(layout, "background", "@android:drawable/popup_full_dark");
        }
        return layout;
    }

    private static void addFidelityWarning(Document document, Element root, String typeName) {
        Element spacer = document.createElement("View");
        root.appendChild(spacer);
        MenuPreviewRenderer.setAndroidAttr(spacer, "layout_width", "fill_parent");
        MenuPreviewRenderer.setAndroidAttr(spacer, "layout_height", "fill_parent");
        MenuPreviewRenderer.setAndroidAttr(spacer, "layout_weight", "1");
        Element warningView = document.createElement("TextView");
        root.appendChild(warningView);
        MenuPreviewRenderer.setAndroidAttr(warningView, "text", "(Note: " + typeName + " preview is only approximate)");
        MenuPreviewRenderer.setAndroidAttr(warningView, "layout_width", "fill_parent");
        MenuPreviewRenderer.setAndroidAttr(warningView, "layout_height", "wrap_content");
        MenuPreviewRenderer.setAndroidAttr(warningView, "layout_margin", "5dp");
        MenuPreviewRenderer.setAndroidAttr(warningView, ATTR_TEXT_COLOR, "#ff0000");
        MenuPreviewRenderer.setAndroidAttr(warningView, "gravity", "center");
    }

    private boolean addActionBar(Element root) {
        ArrayList icons = Lists.newArrayList();
        if (this.myRootTag != null) {
            for (XmlTag tag : this.myRootTag.getSubTags()) {
                String icon = tag.getAttributeValue("icon", "http://schemas.android.com/apk/res/android");
                if (icon == null) continue;
                icons.add(Pair.create((Object)icon, (Object)tag));
                if (icons.size() > 6) break;
            }
        }
        if (!icons.isEmpty()) {
            String name;
            Element linear = this.createActionBar();
            root.appendChild(linear);
            for (Pair pair : icons) {
                String iconUrl = (String)pair.getFirst();
                XmlTag tag = (XmlTag)pair.getSecond();
                String showAsAction = tag.getAttributeValue("showAsAction", "http://schemas.android.com/apk/res/android");
                if (showAsAction == null && (showAsAction = tag.getAttributeValue("showAsAction", "http://schemas.android.com/apk/res-auto")) == null) {
                    showAsAction = "";
                }
                if (showAsAction.contains(VALUE_NEVER)) continue;
                Element imageView = this.myDocument.createElement("ImageView");
                linear.appendChild(imageView);
                MenuPreviewRenderer.setAndroidAttr(imageView, "layout_width", "wrap_content");
                MenuPreviewRenderer.setAndroidAttr(imageView, "layout_height", "wrap_content");
                MenuPreviewRenderer.setAndroidAttr(imageView, "src", iconUrl);
                this.viewCookies.put(imageView, tag);
                if (showAsAction.contains(VALUE_WITH_TEXT)) {
                    String title = tag.getAttributeValue("title", "http://schemas.android.com/apk/res/android");
                    if (title == null) continue;
                    Element textView = this.myDocument.createElement("TextView");
                    linear.appendChild(textView);
                    MenuPreviewRenderer.setAndroidAttr(textView, "text", title);
                    MenuPreviewRenderer.setAndroidAttr(textView, "layout_width", "wrap_content");
                    MenuPreviewRenderer.setAndroidAttr(textView, "layout_height", "wrap_content");
                    MenuPreviewRenderer.setAndroidAttr(textView, "layout_marginRight", "8dp");
                    this.viewCookies.put(textView, tag);
                    continue;
                }
                MenuPreviewRenderer.setAndroidAttr(imageView, "layout_marginRight", "8dp");
            }
            this.myThemeIsLight = true;
            String string = name = this.myThemeIsLight ? "ic_menu_moreoverflow_holo_light" : "ic_menu_moreoverflow_holo_dark";
            if (this.myApiLevel >= 11 && this.myResolver.getFrameworkResource(ResourceType.DRAWABLE, name) != null) {
                Element imageView = this.myDocument.createElement("ImageView");
                linear.appendChild(imageView);
                MenuPreviewRenderer.setAndroidAttr(imageView, "layout_width", "wrap_content");
                MenuPreviewRenderer.setAndroidAttr(imageView, "layout_height", "wrap_content");
                MenuPreviewRenderer.setAndroidAttr(imageView, "src", "@android:drawable/" + name);
                MenuPreviewRenderer.setAndroidAttr(imageView, "layout_marginRight", "8dp");
            }
            return true;
        }
        return false;
    }

    private void populateMenu(@NotNull Element root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/rendering/MenuPreviewRenderer", "populateMenu"));
        }
        boolean dividerSupported = this.myApiLevel >= 11;
        boolean useDividerAttribute = false;
        if (dividerSupported && useDividerAttribute) {
            MenuPreviewRenderer.setAndroidAttr(root, "divider", "?android:attr/actionBarDivider");
            MenuPreviewRenderer.setAndroidAttr(root, "dividerPadding", "12dip");
        }
        String textNormalHeight = this.myApiLevel >= 14 && this.myResolver.findResValue("?android:attr/dropdownListPreferredItemHeight", true) != null ? "?android:attr/dropdownListPreferredItemHeight" : (this.myApiLevel >= 14 && this.myResolver.findResValue("?android:attr/listPreferredItemHeightSmall", true) != null ? "?android:attr/listPreferredItemHeightSmall" : "48dip");
        boolean hasPopupTextAppearance = false;
        if (this.myApiLevel >= 11 && this.myResolver.findResValue("?android:attr/textAppearanceLargePopupMenu", true) != null) {
            hasPopupTextAppearance = true;
        }
        boolean first = root.getChildNodes().getLength() == 0;
        List<MenuItem> items = this.readMenu();
        for (MenuItem menuItem : items) {
            String shortcut;
            String visibility;
            XmlTag item = menuItem.tag;
            if (!menuItem.visible) continue;
            if (first) {
                first = false;
            } else if (!useDividerAttribute) {
                Element imageView = this.myDocument.createElement("ImageView");
                root.appendChild(imageView);
                MenuPreviewRenderer.setAndroidAttr(imageView, "layout_width", "fill_parent");
                MenuPreviewRenderer.setAndroidAttr(imageView, "layout_height", "1dp");
                if (dividerSupported) {
                    MenuPreviewRenderer.setAndroidAttr(imageView, "background", "?android:attr/dividerHorizontal");
                }
            }
            Element listMenuView = this.myDocument.createElement("LinearLayout");
            root.appendChild(listMenuView);
            this.viewCookies.put(listMenuView, item);
            MenuPreviewRenderer.setAndroidAttr(listMenuView, "layout_width", "fill_parent");
            MenuPreviewRenderer.setAndroidAttr(listMenuView, "layout_height", textNormalHeight);
            MenuPreviewRenderer.setAndroidAttr(listMenuView, "minWidth", "196dip");
            MenuPreviewRenderer.setAndroidAttr(listMenuView, "paddingEnd", "16dip");
            Element relative = this.myDocument.createElement("RelativeLayout");
            listMenuView.appendChild(relative);
            MenuPreviewRenderer.setAndroidAttr(relative, "layout_width", "0dp");
            MenuPreviewRenderer.setAndroidAttr(relative, "layout_weight", "1");
            MenuPreviewRenderer.setAndroidAttr(relative, "layout_height", "wrap_content");
            MenuPreviewRenderer.setAndroidAttr(relative, "layout_gravity", "center_vertical");
            MenuPreviewRenderer.setAndroidAttr(relative, "layout_marginLeft", "16dip");
            MenuPreviewRenderer.setAndroidAttr(relative, ATTR_DUPLICATE_PARENT_STATE, "true");
            Element itemView = this.myDocument.createElement("TextView");
            relative.appendChild(itemView);
            MenuPreviewRenderer.setAndroidAttr(itemView, "id", "@+id/title");
            MenuPreviewRenderer.setAndroidAttr(itemView, "layout_width", "wrap_content");
            MenuPreviewRenderer.setAndroidAttr(itemView, "layout_height", "wrap_content");
            MenuPreviewRenderer.setAndroidAttr(itemView, "layout_alignParentTop", "true");
            MenuPreviewRenderer.setAndroidAttr(itemView, "layout_alignParentLeft", "true");
            if (hasPopupTextAppearance) {
                MenuPreviewRenderer.setAndroidAttr(itemView, ATTR_TEXT_APPEARANCE, "?android:attr/textAppearanceLargePopupMenu");
            } else {
                MenuPreviewRenderer.setAndroidAttr(itemView, "textSize", "22sp");
                MenuPreviewRenderer.setAndroidAttr(itemView, ATTR_TEXT_COLOR, "?android:attr/textColorPrimary");
            }
            MenuPreviewRenderer.setAndroidAttr(itemView, "singleLine", "true");
            MenuPreviewRenderer.setAndroidAttr(itemView, ATTR_DUPLICATE_PARENT_STATE, "true");
            if (this.myApiLevel >= 14) {
                MenuPreviewRenderer.setAndroidAttr(itemView, ATTR_ELLIPSIZE, VALUE_MARQUEE);
            }
            MenuPreviewRenderer.setAndroidAttr(itemView, ATTR_FADING_EDGE, "horizontal");
            MenuPreviewRenderer.setAndroidAttr(itemView, ATTR_TEXT_ALIGNMENT, "viewStart");
            String title = item.getAttributeValue("title", "http://schemas.android.com/apk/res/android");
            if (title != null) {
                MenuPreviewRenderer.setAndroidAttr(itemView, "text", title);
            }
            if ((visibility = item.getAttributeValue("visibility", "http://schemas.android.com/apk/res/android")) != null) {
                MenuPreviewRenderer.setAndroidAttr(itemView, "visibility", visibility);
            }
            if (!menuItem.enabled) {
                MenuPreviewRenderer.setAndroidAttr(itemView, "enabled", "false");
            }
            if ((shortcut = item.getAttributeValue(ATTR_ALPHABETIC_SHORTCUT, "http://schemas.android.com/apk/res/android")) == null) {
                shortcut = item.getAttributeValue(ATTR_NUMERIC_SHORTCUT, "http://schemas.android.com/apk/res/android");
            }
            if (shortcut != null) {
                Element shortCut = this.myDocument.createElement("TextView");
                relative.appendChild(shortCut);
                MenuPreviewRenderer.setAndroidAttr(shortCut, "text", shortcut);
                MenuPreviewRenderer.setAndroidAttr(shortCut, "id", "@+id/shortcut");
                MenuPreviewRenderer.setAndroidAttr(shortCut, "layout_width", "wrap_content");
                MenuPreviewRenderer.setAndroidAttr(shortCut, "layout_height", "wrap_content");
                MenuPreviewRenderer.setAndroidAttr(shortCut, "layout_below", "@id/title");
                MenuPreviewRenderer.setAndroidAttr(shortCut, "layout_alignParentLeft", "true");
                if (hasPopupTextAppearance) {
                    MenuPreviewRenderer.setAndroidAttr(shortCut, ATTR_TEXT_APPEARANCE, "?android:attr/textAppearanceSmallPopupMenu");
                } else {
                    MenuPreviewRenderer.setAndroidAttr(shortCut, "textSize", "14sp");
                    MenuPreviewRenderer.setAndroidAttr(shortCut, ATTR_TEXT_COLOR, "?android:attr/textColorSecondary");
                }
                MenuPreviewRenderer.setAndroidAttr(shortCut, "singleLine", "true");
                MenuPreviewRenderer.setAndroidAttr(shortCut, ATTR_DUPLICATE_PARENT_STATE, "true");
                MenuPreviewRenderer.setAndroidAttr(shortCut, ATTR_TEXT_ALIGNMENT, "viewStart");
                if (visibility != null) {
                    MenuPreviewRenderer.setAndroidAttr(shortCut, "visibility", visibility);
                }
            }
            if (menuItem.checkable == 0) continue;
            Element toggle = this.myDocument.createElement(menuItem.checkable == 1 ? "CheckBox" : "RadioButton");
            listMenuView.appendChild(toggle);
            MenuPreviewRenderer.setAndroidAttr(toggle, "layout_width", "wrap_content");
            MenuPreviewRenderer.setAndroidAttr(toggle, "layout_height", "wrap_content");
            MenuPreviewRenderer.setAndroidAttr(toggle, "layout_gravity", "center_vertical");
            MenuPreviewRenderer.setAndroidAttr(toggle, ATTR_FOCUSABLE, "false");
            MenuPreviewRenderer.setAndroidAttr(toggle, ATTR_CLICKABLE, "false");
            MenuPreviewRenderer.setAndroidAttr(toggle, ATTR_DUPLICATE_PARENT_STATE, "true");
            String checked = item.getAttributeValue("checked", "http://schemas.android.com/apk/res/android");
            if (checked != null) {
                toggle.setAttributeNS("http://schemas.android.com/apk/res/android", "checked", checked);
            }
            if (!menuItem.enabled) {
                MenuPreviewRenderer.setAndroidAttr(toggle, "enabled", "false");
            }
            if (visibility == null) continue;
            MenuPreviewRenderer.setAndroidAttr(toggle, "visibility", visibility);
        }
    }

    private List<MenuItem> readMenu() {
        ArrayList items = Lists.newArrayList();
        this.addMenuItems(items, this.myRootTag);
        return items;
    }

    private void addMenuItems(ArrayList<MenuItem> items, XmlTag menuTag) {
        for (XmlTag tag : menuTag.getSubTags()) {
            String tagName = tag.getName();
            if ("item".equals(tagName)) {
                MenuItem item = this.readItem(tag);
                items.add(MenuPreviewRenderer.findInsertIndex(items, item.ordering), item);
                continue;
            }
            if ("group".equals(tagName)) {
                this.readGroup(tag);
                this.addMenuItems(items, tag);
                this.resetGroup();
                continue;
            }
            if (!"menu".equals(tagName)) continue;
        }
    }

    private static boolean getBoolean(XmlTag tag, String attributeName, boolean defaultValue) {
        String value = tag.getAttributeValue(attributeName, "http://schemas.android.com/apk/res/android");
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    private static int getInt(XmlTag tag, String attributeName, int defaultValue) {
        String value = tag.getAttributeValue(attributeName, "http://schemas.android.com/apk/res/android");
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static int getCategory(XmlTag tag, int defaultValue) {
        String category = tag.getAttributeValue(ATTR_MENU_CATEGORY, "http://schemas.android.com/apk/res/android");
        if (category != null) {
            if (category.equals("container")) {
                return 65536;
            }
            if (category.equals("system")) {
                return 131072;
            }
            if (category.equals("secondary")) {
                return 196608;
            }
            if (category.equals("alternative")) {
                return 262144;
            }
        }
        return defaultValue;
    }

    public void resetGroup() {
        this.myGroupCategory = 0;
        this.myGroupOrder = 0;
        this.myGroupCheckable = 0;
        this.myGroupVisible = true;
        this.myGroupEnabled = true;
    }

    public void readGroup(XmlTag tag) {
        assert (tag.getName().equals("group")) : tag.getName();
        this.myGroupCheckable = 0;
        String checkableBehavior = tag.getAttributeValue(ATTR_CHECKABLE_BEHAVIOR, "http://schemas.android.com/apk/res/android");
        this.myGroupCheckable = VALUE_SINGLE.equals(checkableBehavior) ? 1 : (VALUE_ALL.equals(checkableBehavior) ? 2 : 0);
        this.myGroupCategory = MenuPreviewRenderer.getCategory(tag, 0);
        this.myGroupOrder = MenuPreviewRenderer.getInt(tag, ATTR_ORDER_IN_CATEGORY, 0);
        this.myGroupVisible = MenuPreviewRenderer.getBoolean(tag, "visible", true);
        this.myGroupEnabled = MenuPreviewRenderer.getBoolean(tag, "enabled", true);
    }

    public MenuItem readItem(XmlTag tag) {
        assert (tag.getName().equals("item")) : tag.getName();
        int category = MenuPreviewRenderer.getCategory(tag, this.myGroupCategory);
        int order = MenuPreviewRenderer.getInt(tag, ATTR_ORDER_IN_CATEGORY, this.myGroupOrder);
        boolean itemVisible = MenuPreviewRenderer.getBoolean(tag, "visible", this.myGroupVisible);
        boolean itemEnabled = MenuPreviewRenderer.getBoolean(tag, "enabled", this.myGroupEnabled);
        int itemCategoryOrder = category & 0xFFFF0000 | order & 0xFFFF;
        XmlAttribute checkableAttribute = tag.getAttribute(ATTR_CHECKABLE, "http://schemas.android.com/apk/res/android");
        int itemCheckable = checkableAttribute != null ? (Boolean.valueOf(checkableAttribute.getValue()) != false ? 1 : 0) : this.myGroupCheckable;
        return new MenuItem(tag, MenuPreviewRenderer.getOrdering(itemCategoryOrder), itemCheckable, itemVisible, itemEnabled);
    }

    private static int getOrdering(int categoryOrder) {
        int index = (categoryOrder & 0xFFFF0000) >> 16;
        assert (index >= 0 && index < ourCategoryToOrder.length);
        return ourCategoryToOrder[index] << 16 | categoryOrder & 0xFFFF;
    }

    private static int findInsertIndex(ArrayList<MenuItem> items, int ordering) {
        for (int i = items.size() - 1; i >= 0; --i) {
            MenuItem item = items.get(i);
            if (item.ordering > ordering) continue;
            return i + 1;
        }
        return 0;
    }

    private static final class MenuItem {
        public final XmlTag tag;
        public final int ordering;
        public final boolean visible;
        public final boolean enabled;
        public final int checkable;

        public MenuItem(XmlTag tag, int ordering, int checkable, boolean visible, boolean enabled) {
            this.tag = tag;
            this.ordering = ordering;
            this.checkable = checkable;
            this.visible = visible;
            this.enabled = enabled;
        }
    }
}

