/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageComponent
extends OpaquePanel {
    protected BufferedImage myImage = null;

    public ImageComponent() {
    }

    public ImageComponent(@Nullable Icon icon) {
        this.setIcon(icon);
    }

    protected void paintChildren(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/ImageComponent", "paintChildren"));
        }
        if (this.myImage == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        ImageComponent.setRenderingHints(g2);
        g2.drawImage(this.myImage, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.myImage.getWidth(), this.myImage.getHeight(), null);
    }

    public void setIcon(@Nullable Icon icon) {
        if (icon != null) {
            this.myImage = UIUtil.createImage((int)icon.getIconWidth(), (int)icon.getIconHeight(), (int)2);
            Graphics2D gg = this.myImage.createGraphics();
            ImageComponent.setRenderingHints(gg);
            icon.paintIcon((Component)((Object)this), gg, 0, 0);
            gg.dispose();
        } else {
            this.myImage = null;
        }
        this.revalidate();
        this.repaint();
    }

    private static void setRenderingHints(Graphics2D gg) {
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }
}

