/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public final class WizardUtils {
    @NotNull
    public static File getProjectLocationParent() {
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent == null) {
            String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
            File file = new File(SystemProperties.getUserHome(), child);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/WizardUtils", "getProjectLocationParent"));
            }
            return file;
        }
        File file = new File(parent.replace('/', File.separatorChar));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/WizardUtils", "getProjectLocationParent"));
        }
        return file;
    }

    @NotNull
    public static String toHtmlString(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/ui/wizard/WizardUtils", "toHtmlString"));
        }
        if (!StringUtil.isEmpty((String)text) && !text.startsWith("<html>")) {
            String string = String.format("<html>%1$s</html>", text.trim());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/WizardUtils", "toHtmlString"));
            }
            return string;
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/WizardUtils", "toHtmlString"));
        }
        return string;
    }

    @NotNull
    public static URL toUrl(@NotNull String urlAsString) {
        URL url;
        if (urlAsString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlAsString", "com/android/tools/idea/ui/wizard/WizardUtils", "toUrl"));
        }
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        URL uRL = url;
        if (uRL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/WizardUtils", "toUrl"));
        }
        return uRL;
    }
}

