/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressBarHandler
extends ViewHandler {
    private static final String DOT_PROGRESS_BAR_DOT = ".ProgressBar.";
    private static final String PROGRESS_BAR_STYLE = "progressBarStyle";
    private static final String LARGE = "Large";
    private static final String SMALL = "Small";
    private static final String HORIZONTAL = "Horizontal";

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"contentDescription", (Object)"style", (Object)"max", (Object)"progress", (Object)"indeterminate");
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ProgressBarHandler", "getInspectorProperties"));
        }
        return immutableList;
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/ProgressBarHandler", "getTitleAttributes"));
        }
        String style = this.getStyle(component);
        String string = StringUtil.isEmpty((String)style) ? "" : "(" + style + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/ProgressBarHandler", "getTitleAttributes"));
        }
        return string;
    }

    @Nullable
    protected String getStyle(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/ProgressBarHandler", "getStyle"));
        }
        String style = component.getAttribute(null, "style");
        if (style == null) {
            return null;
        }
        if (style.startsWith("@android:style/")) {
            int index = style.indexOf(DOT_PROGRESS_BAR_DOT);
            return ProgressBarHandler.findProgressBarType(style.substring(index + DOT_PROGRESS_BAR_DOT.length()));
        }
        if (style.startsWith("?android:")) {
            int index = style.indexOf(PROGRESS_BAR_STYLE);
            return ProgressBarHandler.findProgressBarType(style.substring(index + PROGRESS_BAR_STYLE.length()));
        }
        return null;
    }

    @Nullable
    private static String findProgressBarType(@NotNull String style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/handlers/ProgressBarHandler", "findProgressBarType"));
        }
        if (style.startsWith(LARGE)) {
            return LARGE;
        }
        if (style.startsWith(SMALL)) {
            return SMALL;
        }
        if (style.startsWith(HORIZONTAL)) {
            return HORIZONTAL;
        }
        return null;
    }
}

