/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.uibuilder.model.ItemTransferable;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import org.jetbrains.annotations.NotNull;

public class NlDropEvent {
    private final DropTargetDragEvent myDragEvent;
    private final DropTargetDropEvent myDropEvent;
    private boolean myStatusSpecified;

    public NlDropEvent(@NotNull DropTargetDragEvent dragEvent) {
        if (dragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dragEvent", "com/android/tools/idea/uibuilder/model/NlDropEvent", "<init>"));
        }
        this.myDragEvent = dragEvent;
        this.myDropEvent = null;
    }

    public NlDropEvent(@NotNull DropTargetDropEvent dropEvent) {
        if (dropEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dropEvent", "com/android/tools/idea/uibuilder/model/NlDropEvent", "<init>"));
        }
        this.myDragEvent = null;
        this.myDropEvent = dropEvent;
    }

    @NotNull
    public Point getLocation() {
        if (this.myDragEvent != null) {
            Point point = this.myDragEvent.getLocation();
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlDropEvent", "getLocation"));
            }
            return point;
        }
        Point point = this.myDropEvent.getLocation();
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlDropEvent", "getLocation"));
        }
        return point;
    }

    public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/android/tools/idea/uibuilder/model/NlDropEvent", "isDataFlavorSupported"));
        }
        if (this.myDragEvent != null) {
            return this.myDragEvent.isDataFlavorSupported(flavor);
        }
        return this.myDropEvent.isDataFlavorSupported(flavor);
    }

    public int getDropAction() {
        if (this.myDragEvent != null) {
            return this.myDragEvent.getDropAction();
        }
        return this.myDropEvent.getDropAction();
    }

    @NotNull
    public Transferable getTransferable() {
        if (!this.myStatusSpecified && !this.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR) && this.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.accept(1);
        }
        if (this.myDragEvent != null) {
            Transferable transferable = this.myDragEvent.getTransferable();
            if (transferable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlDropEvent", "getTransferable"));
            }
            return transferable;
        }
        Transferable transferable = this.myDropEvent.getTransferable();
        if (transferable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlDropEvent", "getTransferable"));
        }
        return transferable;
    }

    public void accept(int dropAction) {
        if (!this.myStatusSpecified) {
            if (this.myDragEvent != null) {
                this.myDragEvent.acceptDrag(dropAction);
            } else {
                this.myDropEvent.acceptDrop(dropAction);
            }
            this.myStatusSpecified = true;
        }
    }

    public void reject() {
        if (!this.myStatusSpecified) {
            if (this.myDragEvent != null) {
                this.myDragEvent.rejectDrag();
            } else {
                this.myDropEvent.rejectDrop();
            }
            this.myStatusSpecified = true;
        }
    }

    public void complete() {
        if (this.myDropEvent != null) {
            this.myDropEvent.dropComplete(true);
        }
    }
}

