/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.Quantity;
import com.android.tools.idea.uibuilder.property.renderer.NlDefaultRenderer;
import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlReferenceEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private static final int MIN_TEXT_WIDTH = 50;
    private final boolean myIncludeBrowseButton;
    private final JPanel myPanel;
    private final JLabel myIconLabel;
    private final JSlider mySlider;
    private final TextEditor myTextFieldWithAutoCompletion;
    private final CompletionProvider myCompletionProvider;
    private final BrowsePanel myBrowsePanel;
    private NlProperty myProperty;
    private boolean myPropertyHasSlider;
    private String myLastReadValue;
    private Object myLastWriteValue;
    private boolean myUpdatingProperty;
    private boolean myCompletionsUpdated;

    public static NlTableCellEditor createForTable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "createForTable"));
        }
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        cellEditor.init(new NlReferenceEditor(project, cellEditor, cellEditor, false, true));
        return cellEditor;
    }

    public static NlReferenceEditor createForInspector(@NotNull Project project, @NotNull NlEditingListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "createForInspector"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "createForInspector"));
        }
        return new NlReferenceEditor(project, listener, null, true, false);
    }

    public static NlReferenceEditor createForInspectorWithBrowseButton(@NotNull Project project, @NotNull NlEditingListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "createForInspectorWithBrowseButton"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "createForInspectorWithBrowseButton"));
        }
        return new NlReferenceEditor(project, listener, null, true, true);
    }

    private NlReferenceEditor(@NotNull Project project, @NotNull NlEditingListener listener, @Nullable BrowsePanel.Context context, boolean includeBorder, boolean includeBrowseButton) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "<init>"));
        }
        super(listener);
        this.myIncludeBrowseButton = includeBrowseButton;
        this.myPanel = new JPanel(new BorderLayout(HORIZONTAL_COMPONENT_GAP, 0));
        this.myIconLabel = new JBLabel();
        this.myPanel.add((Component)this.myIconLabel, "Before");
        this.myIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NlReferenceEditor.this.displayResourcePicker();
            }
        });
        this.mySlider = new JSlider();
        this.myPanel.add((Component)this.mySlider, "Before");
        this.mySlider.addChangeListener(event -> this.sliderChange());
        Dimension size = this.mySlider.getMinimumSize();
        size.setSize(size.width * 2, size.height);
        this.mySlider.setPreferredSize(size);
        this.myCompletionProvider = new CompletionProvider();
        this.myTextFieldWithAutoCompletion = new TextEditor(project, this.myCompletionProvider);
        if (includeBorder) {
            this.myTextFieldWithAutoCompletion.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        }
        this.myBrowsePanel = this.createBrowsePanel(context);
        this.myPanel.add((Component)((Object)this.myTextFieldWithAutoCompletion), "Center");
        this.myPanel.add((Component)this.myBrowsePanel, "After");
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                NlReferenceEditor.this.updateSliderVisibility();
            }
        });
        this.myTextFieldWithAutoCompletion.registerKeyboardAction(event -> this.stopEditing(this.getText()), KeyStroke.getKeyStroke(10, 0), 1);
        this.myTextFieldWithAutoCompletion.registerKeyboardAction(event -> this.stopEditing(this.myProperty.getValue()), KeyStroke.getKeyStroke(27, 0), 1);
        this.myTextFieldWithAutoCompletion.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!NlReferenceEditor.this.myCompletionsUpdated) {
                    NlReferenceEditor.this.myCompletionProvider.updateCompletions(NlReferenceEditor.this.myProperty);
                    NlReferenceEditor.this.myCompletionsUpdated = true;
                }
                NlReferenceEditor.this.myTextFieldWithAutoCompletion.selectAll();
            }

            @Override
            public void focusLost(FocusEvent event) {
                NlReferenceEditor.this.stopEditing(NlReferenceEditor.this.getText());
                NlReferenceEditor.this.myTextFieldWithAutoCompletion.removeSelection();
            }
        });
    }

    @NotNull
    private String getText() {
        String text = this.myTextFieldWithAutoCompletion.getDocument().getText();
        String string = Quantity.addUnit(this.myProperty, text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "getText"));
        }
        return string;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTextFieldWithAutoCompletion.setEnabled(enabled);
        this.myBrowsePanel.setVisible(enabled && this.myIncludeBrowseButton);
    }

    @Override
    public NlProperty getProperty() {
        return this.myProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "setProperty"));
        }
        if (this.myProperty != property) {
            this.myProperty = property;
            this.myLastReadValue = null;
            if (this.myIncludeBrowseButton) {
                this.myBrowsePanel.setProperty(property);
            }
            this.myCompletionsUpdated = false;
        }
        this.myUpdatingProperty = true;
        try {
            this.myPropertyHasSlider = this.configureSlider();
            if (this.myPropertyHasSlider) {
                this.myPanel.remove(this.myIconLabel);
                this.myPanel.add((Component)this.mySlider, "Before");
            } else {
                this.myPanel.remove(this.mySlider);
                this.myPanel.add((Component)this.myIconLabel, "Before");
                Icon icon = NlDefaultRenderer.getIcon(this.myProperty);
                this.myIconLabel.setIcon(icon);
                this.myIconLabel.setVisible(icon != null);
            }
            String propValue = StringUtil.notNullize((String)this.myProperty.getValue());
            if (!propValue.equals(this.myLastReadValue)) {
                this.myLastReadValue = propValue;
                this.myLastWriteValue = propValue;
                this.myTextFieldWithAutoCompletion.setText(propValue);
            }
            JBColor color = this.myProperty.isDefaultValue(this.myLastReadValue) ? DEFAULT_VALUE_TEXT_COLOR : CHANGED_VALUE_TEXT_COLOR;
            this.myTextFieldWithAutoCompletion.setTextColor((Color)color);
        }
        finally {
            this.myUpdatingProperty = false;
        }
    }

    private void updateSliderVisibility() {
        if (this.myPropertyHasSlider) {
            int widthForEditor = this.myPanel.getWidth() - this.mySlider.getPreferredSize().width - this.myBrowsePanel.getPreferredSize().width;
            this.mySlider.setVisible(widthForEditor >= 50);
        }
    }

    private boolean configureSlider() {
        int value;
        int maximum;
        if (this.myProperty == null) {
            return false;
        }
        AttributeDefinition definition = this.myProperty.getDefinition();
        if (definition == null || Collections.disjoint(definition.getFormats(), ImmutableList.of((Object)((Object)AttributeFormat.Dimension), (Object)((Object)AttributeFormat.Float)))) {
            return false;
        }
        switch (this.myProperty.getName()) {
            case "elevation": 
            case "cardElevation": {
                maximum = 24;
                value = this.getValueInDp(0);
                break;
            }
            case "minHeight": {
                maximum = 250;
                value = this.getValueInDp(180);
                break;
            }
            case "layout_collapseParallaxMultiplier": {
                maximum = 10;
                value = (int)(this.getValueAsFloat(1.0) * 10.0 + 0.5);
                break;
            }
            default: {
                return false;
            }
        }
        this.mySlider.setMinimum(0);
        this.mySlider.setMaximum(maximum);
        this.mySlider.setValue(value);
        return true;
    }

    private int getValueInDp(int defaultValue) {
        String valueAsString = this.myProperty.getValue();
        if (valueAsString == null) {
            return defaultValue;
        }
        Configuration configuration = this.myProperty.getModel().getConfiguration();
        Integer value = ResourceHelper.resolveDimensionPixelSize((RenderResources)this.myProperty.getResolver(), valueAsString, configuration);
        if (value == null) {
            return defaultValue;
        }
        return value * 160 / configuration.getDensity().getDpiValue();
    }

    private double getValueAsFloat(double defaultValue) {
        String valueAsString = this.myProperty.getValue();
        if (valueAsString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueAsString);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    private String getSliderValue() {
        int value = this.mySlider.getValue();
        switch (this.myProperty.getName()) {
            case "layout_collapseParallaxMultiplier": {
                if (value == 10) {
                    return "1.0";
                }
                return "0." + value;
            }
        }
        return Quantity.addUnit(this.myProperty, String.valueOf(value));
    }

    private void sliderChange() {
        if (this.myUpdatingProperty) {
            return;
        }
        this.myTextFieldWithAutoCompletion.setText(this.getSliderValue());
        if (!this.mySlider.getValueIsAdjusting()) {
            this.stopEditing(this.getText());
        }
    }

    @Override
    public void requestFocus() {
        this.myTextFieldWithAutoCompletion.requestFocus();
        this.myTextFieldWithAutoCompletion.selectAll();
        this.myTextFieldWithAutoCompletion.scrollRectToVisible(this.myTextFieldWithAutoCompletion.getBounds());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public Object getValue() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor", "getValue"));
        }
        return string;
    }

    @Override
    public void stopEditing(@Nullable Object newValue) {
        this.myTextFieldWithAutoCompletion.setText((String)newValue);
        if (this.hasFocus()) {
            this.myTextFieldWithAutoCompletion.selectAll();
        }
        if (!Objects.equals(newValue, this.myLastWriteValue)) {
            this.myLastWriteValue = newValue;
            this.myLastReadValue = null;
            super.stopEditing(newValue);
        }
    }

    private boolean hasFocus() {
        if (this.myTextFieldWithAutoCompletion.hasFocus()) {
            return true;
        }
        Editor editor = this.myTextFieldWithAutoCompletion.getEditor();
        return editor != null && editor.getContentComponent().hasFocus();
    }

    private static class CompletionProvider
    extends TextFieldWithAutoCompletionListProvider<String> {
        protected CompletionProvider() {
            super(null);
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$CompletionProvider", "createPrefixMatcher"));
            }
            return new CamelHumpMatcher(prefix);
        }

        @Nullable
        protected Icon getIcon(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$CompletionProvider", "getIcon"));
            }
            return item.startsWith("@android:") ? AndroidIcons.Android : null;
        }

        @NotNull
        protected String getLookupString(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$CompletionProvider", "getLookupString"));
            }
            String string = item;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$CompletionProvider", "getLookupString"));
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$CompletionProvider", "getTailText"));
            }
            return null;
        }

        @Nullable
        protected String getTypeText(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$CompletionProvider", "getTypeText"));
            }
            return null;
        }

        public int compare(String item1, String item2) {
            return ResourceHelper.compareResourceReferences(item1, item2);
        }

        public void updateCompletions(@NotNull NlProperty property) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$CompletionProvider", "updateCompletions"));
            }
            AttributeDefinition definition = property.getDefinition();
            if (definition == null) {
                this.setItems(null);
                return;
            }
            EnumSet<ResourceType> types = BrowsePanel.getResourceTypes(property.getName(), definition);
            if (types.contains(ResourceType.MIPMAP)) {
                types = types.clone();
                types.remove(ResourceType.MIPMAP);
                types.add(ResourceType.DRAWABLE);
            }
            if (types.contains(ResourceType.ID) && "id".equals(property.getName())) {
                this.setItems(null);
                return;
            }
            AndroidFacet facet = property.getModel().getFacet();
            this.setItems(ResourceHelper.getCompletionFromTypes(facet, types, false));
        }
    }

    private static class TextEditor
    extends TextFieldWithAutoCompletion<String> {
        private final TextAttributes myTextAttributes;

        public TextEditor(@NotNull Project project, @NotNull CompletionProvider provider) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$TextEditor", "<init>"));
            }
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$TextEditor", "<init>"));
            }
            super(project, (TextFieldWithAutoCompletionListProvider)provider, true, null);
            this.myTextAttributes = new TextAttributes((Color)NlBaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR, null, null, null, 0);
        }

        public void addNotify() {
            super.addNotify();
            EditorEx editor = (EditorEx)this.getEditor();
            assert (editor != null);
            editor.getColorsScheme().setAttributes(HighlighterColors.TEXT, this.myTextAttributes);
            editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(this.myTextAttributes));
            editor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)true);
            editor.setBorder((Border)new DarculaEditorTextFieldBorder(){

                public Insets getBorderInsets(Component c) {
                    return new InsetsUIResource(4, 7, 4, 7);
                }
            });
        }

        public void setTextColor(@NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$TextEditor", "setTextColor"));
            }
            this.myTextAttributes.setForegroundColor(color);
            EditorEx editor = (EditorEx)this.getEditor();
            if (editor != null) {
                editor.getColorsScheme().setAttributes(HighlighterColors.TEXT, this.myTextAttributes);
                editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(this.myTextAttributes));
            }
        }
    }
}

