/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlDefaultRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagItemRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagRenderer;
import java.util.Set;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class NlPropertyRenderers {
    private static NlDefaultRenderer ourDefaultRenderer;
    private static NlBooleanRenderer ourBooleanRenderer;
    private static NlFlagRenderer ourFlagRenderer;
    private static NlFlagItemRenderer ourFlagItemRenderer;

    @NotNull
    public static TableCellRenderer get(@NotNull NlProperty p) {
        NlAttributeRenderer renderer;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "get"));
        }
        AttributeDefinition definition = p.getDefinition();
        if (definition == null) {
            NlDefaultRenderer nlDefaultRenderer = NlPropertyRenderers.getDefaultRenderer();
            if (nlDefaultRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "get"));
            }
            return nlDefaultRenderer;
        }
        Set<AttributeFormat> formats = definition.getFormats();
        if (formats.size() == 1 && formats.contains((Object)AttributeFormat.Boolean) && ((NlBooleanRenderer)(renderer = NlPropertyRenderers.getBooleanRenderer())).canRender(p, formats)) {
            NlAttributeRenderer nlAttributeRenderer = renderer;
            if (nlAttributeRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "get"));
            }
            return nlAttributeRenderer;
        }
        if (formats.contains((Object)AttributeFormat.Flag) && ((NlFlagRenderer)(renderer = NlPropertyRenderers.getFlagRenderer())).canRender(p, formats)) {
            NlAttributeRenderer nlAttributeRenderer = renderer;
            if (nlAttributeRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "get"));
            }
            return nlAttributeRenderer;
        }
        NlDefaultRenderer nlDefaultRenderer = NlPropertyRenderers.getDefaultRenderer();
        if (nlDefaultRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "get"));
        }
        return nlDefaultRenderer;
    }

    @NotNull
    public static NlFlagRenderer getFlagRenderer() {
        if (ourFlagRenderer == null) {
            ourFlagRenderer = new NlFlagRenderer();
        }
        NlFlagRenderer nlFlagRenderer = ourFlagRenderer;
        if (nlFlagRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "getFlagRenderer"));
        }
        return nlFlagRenderer;
    }

    @NotNull
    public static NlFlagItemRenderer getFlagItemRenderer() {
        if (ourFlagItemRenderer == null) {
            ourFlagItemRenderer = new NlFlagItemRenderer();
        }
        NlFlagItemRenderer nlFlagItemRenderer = ourFlagItemRenderer;
        if (nlFlagItemRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "getFlagItemRenderer"));
        }
        return nlFlagItemRenderer;
    }

    @NotNull
    private static NlBooleanRenderer getBooleanRenderer() {
        if (ourBooleanRenderer == null) {
            ourBooleanRenderer = new NlBooleanRenderer();
        }
        NlBooleanRenderer nlBooleanRenderer = ourBooleanRenderer;
        if (nlBooleanRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "getBooleanRenderer"));
        }
        return nlBooleanRenderer;
    }

    @NotNull
    private static NlDefaultRenderer getDefaultRenderer() {
        if (ourDefaultRenderer == null) {
            ourDefaultRenderer = new NlDefaultRenderer();
        }
        NlDefaultRenderer nlDefaultRenderer = ourDefaultRenderer;
        if (nlDefaultRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/renderer/NlPropertyRenderers", "getDefaultRenderer"));
        }
        return nlDefaultRenderer;
    }
}

