/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.androidstudio.actions;

import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

enum Kind {
    ANNOTATION("Annotation", PlatformIcons.ANNOTATION_TYPE_ICON),
    CLASS("Class", PlatformIcons.CLASS_ICON),
    ENUM("Enum", PlatformIcons.ENUM_ICON),
    INTERFACE("Interface", PlatformIcons.INTERFACE_ICON);

    private final String myName;
    private final Icon myIcon;

    private Kind(String name, Icon icon) {
        this.myName = name;
        this.myIcon = icon;
    }

    String getName() {
        return this.myName;
    }

    Icon getIcon() {
        return this.myIcon;
    }

    String getTemplateName() {
        return "AS" + this.myName;
    }

    @Nullable
    static Kind valueOfText(String text) {
        for (Kind kind : Kind.values()) {
            if (!kind.getTemplateName().equals(text)) continue;
            return kind;
        }
        return null;
    }
}

