/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidConnectDebuggerAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        if (!AndroidSdkUtils.activateDdmsIfNecessary(project)) {
            return;
        }
        AndroidProcessChooserDialog dialog = new AndroidProcessChooserDialog(project, true);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            Client client = dialog.getClient();
            if (client == null) {
                return;
            }
            AndroidConnectDebuggerAction.closeOldSessionAndRun(project, dialog.getAndroidDebugger(), client);
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = e.getProject();
        e.getPresentation().setVisible(project != null && ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).size() > 0);
    }

    private static void closeOldSessionAndRun(@NotNull Project project, @NotNull AndroidDebugger androidDebugger, @NotNull Client client) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/AndroidConnectDebuggerAction", "closeOldSessionAndRun"));
        }
        if (androidDebugger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidDebugger", "org/jetbrains/android/actions/AndroidConnectDebuggerAction", "closeOldSessionAndRun"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/android/actions/AndroidConnectDebuggerAction", "closeOldSessionAndRun"));
        }
        AndroidConnectDebuggerAction.terminateRunSessions(project, client);
        androidDebugger.attachToClient(project, client);
    }

    private static void terminateRunSessions(@NotNull Project project, @NotNull Client selectedClient) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/AndroidConnectDebuggerAction", "terminateRunSessions"));
        }
        if (selectedClient == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedClient", "org/jetbrains/android/actions/AndroidConnectDebuggerAction", "terminateRunSessions"));
        }
        int pid = selectedClient.getClientData().getPid();
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            Client client;
            if (!(handler instanceof AndroidProcessHandler) || (client = ((AndroidProcessHandler)handler).getClient(selectedClient.getDevice())) == null || client.getClientData().getPid() != pid) continue;
            ((AndroidProcessHandler)handler).setNoKill();
            handler.detachProcess();
            handler.notifyTextAvailable("Disconnecting run session: a new debug session will be established.\n", ProcessOutputTypes.STDOUT);
            break;
        }
    }
}

