/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeDefinition {
    private final String myName;
    private final List<String> myParentStyleables;
    private final Set<AttributeFormat> myFormats;
    private final List<String> myValues;
    private final Map<String, String> myStyleable2DocValue;
    private final Map<String, String> myValueDoc;
    private String myGlobalDocValue;
    private String myAttrGroup;

    public AttributeDefinition(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinition", "<init>"));
        }
        this(name, null, Collections.emptySet());
    }

    public AttributeDefinition(@NotNull String name, @Nullable String parentStyleableName, @NotNull Collection<AttributeFormat> formats) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinition", "<init>"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "org/jetbrains/android/dom/attrs/AttributeDefinition", "<init>"));
        }
        this.myParentStyleables = ContainerUtil.newSmartList();
        this.myFormats = EnumSet.noneOf(AttributeFormat.class);
        this.myValues = new ArrayList<String>();
        this.myStyleable2DocValue = new HashMap<String, String>();
        this.myValueDoc = new HashMap<String, String>();
        this.myName = name;
        if (parentStyleableName != null && !this.myParentStyleables.contains(parentStyleableName)) {
            this.myParentStyleables.add(parentStyleableName);
        }
        this.myFormats.addAll(formats);
    }

    public void addValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinition", "addValue"));
        }
        this.myValues.add(name);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinition", "getName"));
        }
        return string;
    }

    @NotNull
    public List<String> getParentStyleables() {
        List<String> list = this.myParentStyleables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinition", "getParentStyleables"));
        }
        return list;
    }

    @NotNull
    public Set<AttributeFormat> getFormats() {
        Set<AttributeFormat> set = Collections.unmodifiableSet(this.myFormats);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinition", "getFormats"));
        }
        return set;
    }

    @Nullable
    public String getAttrGroup() {
        return this.myAttrGroup;
    }

    public void setAttrGroup(@Nullable String attrGroup) {
        this.myAttrGroup = attrGroup;
    }

    public void addFormats(@NotNull Collection<AttributeFormat> format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/android/dom/attrs/AttributeDefinition", "addFormats"));
        }
        this.myFormats.addAll(format);
    }

    @NotNull
    public String[] getValues() {
        String[] stringArray = ArrayUtil.toStringArray(this.myValues);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinition", "getValues"));
        }
        return stringArray;
    }

    @Nullable
    public String getDocValue(@Nullable String parentStyleable) {
        if (parentStyleable == null || !this.myStyleable2DocValue.containsKey(parentStyleable)) {
            return this.myGlobalDocValue;
        }
        return this.myStyleable2DocValue.get(parentStyleable);
    }

    public void addDocValue(@NotNull String docValue, @Nullable String parentStyleable) {
        if (docValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docValue", "org/jetbrains/android/dom/attrs/AttributeDefinition", "addDocValue"));
        }
        if (parentStyleable == null || this.myGlobalDocValue == null) {
            this.myGlobalDocValue = docValue;
        }
        if (parentStyleable != null) {
            this.myStyleable2DocValue.put(parentStyleable, docValue);
        }
    }

    public String toString() {
        return this.myName + " [" + this.myFormats + ']';
    }

    public void addValueDoc(@NotNull String value, @NotNull String doc) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/dom/attrs/AttributeDefinition", "addValueDoc"));
        }
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "org/jetbrains/android/dom/attrs/AttributeDefinition", "addValueDoc"));
        }
        this.myValueDoc.put(value, doc);
    }

    @Nullable
    public String getValueDoc(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/dom/attrs/AttributeDefinition", "getValueDoc"));
        }
        return this.myValueDoc.get(value);
    }

    public boolean isAttributeDeprecated() {
        String doc = this.getDocValue(null);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }

    public boolean isValueDeprecated(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/dom/attrs/AttributeDefinition", "isValueDeprecated"));
        }
        String doc = this.myValueDoc.get(value);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }
}

