/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AppResourceRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleItemNameConverter
extends ResolvingConverter<String> {
    @Nullable(value="if the tag is null or doesn't define a parent")
    private static String getParentNameFromTag(@Nullable XmlTag styleTag) {
        if (styleTag == null) {
            return null;
        }
        String parentName = styleTag.getAttributeValue("parent");
        if (parentName == null) {
            String styleName = styleTag.getAttributeValue("name");
            if (styleName == null) {
                return null;
            }
            int lastDot = styleName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            parentName = styleName.substring(0, lastDot);
        } else if (parentName.startsWith("@style/")) {
            parentName = StringUtil.trimStart((String)parentName, (String)"@style/");
        } else if (parentName.startsWith("@android:style/")) {
            parentName = "android:" + StringUtil.trimStart((String)parentName, (String)"@android:style/");
        }
        return parentName;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        AttributeDefinitions attrDefs;
        SystemResourceManager manager;
        ArrayList result = Lists.newArrayList();
        if (context.getModule() != null && context.getTag() != null) {
            List parentDefinitions;
            AppResourceRepository appResourceRepository = AppResourceRepository.getAppResources(context.getModule(), true);
            XmlTag styleTag = context.getTag().getParentTag();
            String parent = StyleItemNameConverter.getParentNameFromTag(styleTag);
            List list = parentDefinitions = parent != null && appResourceRepository != null ? appResourceRepository.getResourceItem(ResourceType.STYLE, parent) : null;
            if (parentDefinitions != null && !parentDefinitions.isEmpty()) {
                HashSet attributeNames = Sets.newHashSet();
                LinkedList toExplore = Lists.newLinkedList((Iterable)parentDefinitions);
                int i = 0;
                while (!toExplore.isEmpty() && i++ < 50) {
                    ResourceItem parentItem = (ResourceItem)toExplore.pop();
                    StyleResourceValue parentValue = (StyleResourceValue)parentItem.getResourceValue(false);
                    if (parentValue == null || parentValue.isFramework()) continue;
                    for (ItemResourceValue value : parentValue.getValues()) {
                        if (value.isFramework()) continue;
                        attributeNames.add(value.getName());
                    }
                    List parents = appResourceRepository.getResourceItem(ResourceType.STYLE, parentValue.getParentStyle());
                    if (parents == null) continue;
                    toExplore.addAll(parents);
                }
                result.addAll(attributeNames);
            }
        }
        if ((manager = SystemResourceManager.getInstance(context)) != null && (attrDefs = ((ResourceManager)manager).getAttributeDefinitions()) != null) {
            for (String name : attrDefs.getAttributeNames()) {
                result.add("android:" + name);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/StyleItemNameConverter", "getVariants"));
        }
        return arrayList;
    }

    public LookupElement createLookupElement(String s) {
        if (s == null) {
            return null;
        }
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s), (double)(s.startsWith("android:") ? 0.0 : 1.0));
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        AttributeDefinitions attrDefs;
        SystemResourceManager manager;
        if (s == null) {
            return null;
        }
        String[] strs = s.split(":");
        if (strs.length < 2 || !"android".equals(strs[0])) {
            return s;
        }
        if (strs.length == 2 && (manager = SystemResourceManager.getInstance(context)) != null && (attrDefs = ((ResourceManager)manager).getAttributeDefinitions()) != null && attrDefs.getAttrDefByName(strs[1]) != null) {
            return s;
        }
        return null;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }
}

