/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidAddLibraryDependencyAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        String string = AndroidBundle.message("add.dependency.intention.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    private static GradleBuildModel getGradleBuildModel(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "getGradleBuildModel"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "getGradleBuildModel"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = index.getModuleForFile(file.getVirtualFile());
        if (module == null) {
            return null;
        }
        return GradleBuildModel.get(module);
    }

    @NotNull
    private static ImmutableCollection<String> findAllDependencies(@NotNull GradleBuildModel buildModel) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "findAllDependencies"));
        }
        HashSet existingDependencies = Sets.newHashSet();
        for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts()) {
            existingDependencies.add(dependency.group().value() + ":" + dependency.name().value());
        }
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        RepositoryUrlManager repositoryUrlManager = RepositoryUrlManager.get();
        for (SupportLibrary library : SupportLibrary.values()) {
            GradleCoordinate coordinate;
            GradleCoordinate libraryCoordinate = library.getGradleCoordinate("+");
            if (existingDependencies.contains(libraryCoordinate.getId()) || (coordinate = repositoryUrlManager.resolveDynamicCoordinate(libraryCoordinate, buildModel.getProject())) == null) continue;
            dependenciesBuilder.add((Object)coordinate.toString());
        }
        ImmutableList immutableList = dependenciesBuilder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "findAllDependencies"));
        }
        return immutableList;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "isAvailable"));
        }
        if (!(file instanceof GroovyFile) || !file.getName().equals("build.gradle")) {
            return false;
        }
        if (!AndroidFacet.hasAndroid(project)) {
            return false;
        }
        GradleBuildModel buildModel = AndroidAddLibraryDependencyAction.getGradleBuildModel(project, file);
        if (buildModel == null || buildModel.dependencies().all().isEmpty()) {
            return false;
        }
        return !AndroidAddLibraryDependencyAction.findAllDependencies(buildModel).isEmpty();
    }

    private static void addDependency(@NotNull Project project, final @NotNull GradleBuildModel buildModel, @NotNull String coordinateString) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "addDependency"));
        }
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "addDependency"));
        }
        if (coordinateString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinateString", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "addDependency"));
        }
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)coordinateString);
        if (coordinate == null || coordinate.getArtifactId() == null) {
            return;
        }
        final ArtifactDependencySpec newDependency = new ArtifactDependencySpec(coordinate.getArtifactId(), coordinate.getGroupId(), coordinate.getRevision());
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                buildModel.dependencies().addArtifact("compile", newDependency);
                buildModel.applyChanges();
            }
        });
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction", "invoke"));
        }
        GradleBuildModel buildModel = AndroidAddLibraryDependencyAction.getGradleBuildModel(project, file);
        if (buildModel == null) {
            return;
        }
        ImmutableCollection<String> dependencies = AndroidAddLibraryDependencyAction.findAllDependencies(buildModel);
        if (dependencies.isEmpty()) {
            return;
        }
        JBList list = new JBList(dependencies);
        JBPopup popup = new PopupChooserBuilder((JList)list).setItemChoosenCallback(new Runnable((JList)list, project, buildModel){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            final /* synthetic */ GradleBuildModel val$buildModel;
            {
                this.val$list = jList;
                this.val$project = project;
                this.val$buildModel = gradleBuildModel;
            }

            @Override
            public void run() {
                for (Object selectedValue : this.val$list.getSelectedValues()) {
                    if (selectedValue == null) {
                        return;
                    }
                    AndroidAddLibraryDependencyAction.addDependency(this.val$project, this.val$buildModel, (String)selectedValue);
                }
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

