/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.AnnotationSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.contexts.model.ComponentScannedApplicationContext;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationSpringModelImpl
extends AnnotationSpringModel {
    private final Set<PsiClass> myConfigClasses;

    public AnnotationSpringModelImpl(@NotNull Set<PsiClass> classes, @NotNull Module module, @Nullable SpringFileSet fileSet) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "<init>"));
        }
        super(module, fileSet);
        this.myConfigClasses = classes;
    }

    @NotNull
    public Module getModule() {
        Module module = super.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "getModule"));
        }
        return module;
    }

    @NotNull
    public Set<CommonSpringModel> getModelsToProcess(boolean checkActiveProfiles) {
        Set<PsiPackage> packages;
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        Set<LocalAnnotationModel> localAnnotationModels = this.getLocalAnnotationSpringModels(checkActiveProfiles);
        models.addAll(localAnnotationModels);
        LinkedHashSet<PsiClass> simpleBeans = new LinkedHashSet<PsiClass>();
        for (PsiClass configClass : this.myConfigClasses) {
            if (AnnotationSpringModelImpl.isConfiguration(configClass)) continue;
            simpleBeans.add(configClass);
        }
        if (!simpleBeans.isEmpty()) {
            models.add((CommonSpringModel)new BeansSpringModel(this.getModule(), simpleBeans));
        }
        if (!(packages = this.getComponentScanPackages()).isEmpty()) {
            models.add((CommonSpringModel)new ComponentScanPackagesModel((NotNullLazyValue)new NotNullLazyValue<Set<PsiPackage>>(){

                @NotNull
                protected Set<PsiPackage> compute() {
                    Set set = packages;
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl$1", "compute"));
                    }
                    return set;
                }
            }, this.getModule()));
        }
        models.addAll(this.getDependencies());
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "getModelsToProcess"));
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<PsiPackage> getComponentScanPackages() {
        SpringFileSet set = this.getFileSet();
        if (!(set instanceof ComponentScannedApplicationContext)) {
            Set<PsiPackage> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "getComponentScanPackages"));
            }
            return set2;
        }
        LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
        for (String pkg : ((ComponentScannedApplicationContext)set).getComponentScanPackages()) {
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.getModule().getProject()).findPackage(pkg);
            ContainerUtil.addIfNotNull(packages, (Object)psiPackage);
        }
        LinkedHashSet<PsiPackage> linkedHashSet = packages;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "getComponentScanPackages"));
        }
        return linkedHashSet;
    }

    private Set<LocalAnnotationModel> getLocalAnnotationSpringModels(boolean checkActiveProfiles) {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        for (PsiClass aClass : this.myConfigClasses) {
            Set profiles;
            SpringConfiguration springConfiguration = AnnotationSpringModelImpl.getConfiguration(aClass);
            Set activeProfiles = this.getActiveProfiles();
            if (springConfiguration == null || checkActiveProfiles && !AnnotationSpringModelImpl.isInActiveProfile(springConfiguration, activeProfiles)) continue;
            Set set = profiles = activeProfiles == null || !checkActiveProfiles ? Collections.emptySet() : activeProfiles;
            LocalAnnotationModel model = SpringCachedModelFactory.getOrCreateLocalAnnotationModel(springConfiguration, this.getModule(), (Set<String>)profiles);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    private static boolean isConfiguration(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "isConfiguration"));
        }
        return AnnotationSpringModelImpl.getConfiguration(aClass) != null;
    }

    @Nullable
    private static SpringConfiguration getConfiguration(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "getConfiguration"));
        }
        return aClass.isValid() ? (SpringConfiguration)JamService.getJamService((Project)aClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)aClass) : null;
    }

    public static boolean isInActiveProfile(@NotNull SpringConfiguration configuration, @Nullable Set<String> activeProfiles) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "isInActiveProfile"));
        }
        if (activeProfiles == null || activeProfiles.size() == 0) {
            return true;
        }
        SpringProfile profile = configuration.getProfile();
        if (profile == SpringProfile.DEFAULT) {
            return true;
        }
        return SpringProfileUtils.isActive((Set)profile.getNames(), activeProfiles);
    }

    @NotNull
    public Set<String> getAllProfiles() {
        LinkedHashSet profiles = ContainerUtil.newLinkedHashSet();
        for (CommonSpringModel commonSpringModel : this.getLocalAnnotationSpringModels(false)) {
            profiles.addAll(commonSpringModel.getAllProfiles());
        }
        LinkedHashSet linkedHashSet = profiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl", "getAllProfiles"));
        }
        return linkedHashSet;
    }
}

