/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.groovy;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCallExpressionTypeCalculator;

public class ContextMethodsReturnTypeCalculator
extends GrCallExpressionTypeCalculator {
    public PsiType calculateReturnType(@NotNull GrMethodCall callExpression, @NotNull PsiMethod method) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/spring/groovy/ContextMethodsReturnTypeCalculator", "calculateReturnType"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/groovy/ContextMethodsReturnTypeCalculator", "calculateReturnType"));
        }
        if (!"getBean".equals(method.getName())) {
            return null;
        }
        GrArgumentList argumentList = callExpression.getArgumentList();
        GrExpression[] arguments = argumentList.getExpressionArguments();
        if (arguments.length == 0) {
            return null;
        }
        if (!(arguments[0] instanceof GrLiteralImpl)) {
            return null;
        }
        GrLiteralImpl beanNameLiteral = (GrLiteralImpl)arguments[0];
        Object beanName = beanNameLiteral.getValue();
        if (!(beanName instanceof String)) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parameterCount = parameterList.getParametersCount();
        if (!(parameterCount == 1 || parameterCount == 2 && parameterList.getParameters()[1].getType() instanceof PsiArrayType)) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.springframework.beans.factory.BeanFactory")) {
            return null;
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((PsiElement)callExpression);
        SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)((String)beanName));
        if (bean == null) {
            return null;
        }
        return TypesUtil.getLeastUpperBound((PsiType[])bean.getEffectiveBeanTypes(), (PsiManager)aClass.getManager());
    }
}

