/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.highlighting.SpringCacheableBaseInspection;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroups;
import com.intellij.spring.model.cacheable.jam.SpringJamBaseCacheableElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCacheableComponentsInspection
extends SpringCacheableBaseInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection", "checkMethod"));
        }
        if (SpringCacheableComponentsInspection.isPlainJavaFileInSpringModule((PsiElement)method)) {
            ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
            List elements = SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamBaseCacheableElement.CACHEABLE_BASE_JAM_KEY, (PsiElement)method);
            for (SpringJamBaseCacheableElement cacheable : elements) {
                PsiAnnotation annotation;
                if (!method.getModifierList().hasModifierProperty("public") && (annotation = cacheable.getAnnotation()) != null) {
                    holder.registerProblem((PsiElement)annotation, SpringBundle.message("cacheable.annotations.should.be.defined.on.public.methods", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                this.checkBeansResolve(cacheable, holder);
            }
            return holder.getResultsArray();
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection", "checkClass"));
        }
        if (SpringCacheableComponentsInspection.isPlainJavaFileInSpringModule((PsiElement)aClass)) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            List elements = SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringJamBaseCacheableElement.CACHEABLE_BASE_JAM_KEY, (PsiElement)aClass);
            for (SpringJamBaseCacheableElement cacheable : elements) {
                this.checkBeansResolve(cacheable, holder);
            }
            SpringCachingGroups cachingGroups = (SpringCachingGroups)JamService.getJamService((Project)aClass.getProject()).getJamElement((PsiElement)aClass, new JamMemberMeta[]{SpringCachingGroups.META});
            if (cachingGroups != null) {
                for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCacheables()) {
                    this.checkBeansResolve(springJamBaseCacheableElement, holder);
                }
                for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCachePuts()) {
                    this.checkBeansResolve(springJamBaseCacheableElement, holder);
                }
                for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCacheEvict()) {
                    this.checkBeansResolve(springJamBaseCacheableElement, holder);
                }
            }
            return holder.getResultsArray();
        }
        return null;
    }

    private void checkBeansResolve(@NotNull SpringJamBaseCacheableElement cacheable, @NotNull ProblemsHolder holder) {
        if (cacheable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheable", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection", "checkBeansResolve"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection", "checkBeansResolve"));
        }
        SpringCacheableComponentsInspection.checkBeanPointerResolve((ProblemsHolder)holder, cacheable.getCacheManagerElement(), (String)"org.springframework.cache.CacheManager");
        SpringCacheableComponentsInspection.checkBeanPointerResolve((ProblemsHolder)holder, cacheable.getCacheResolverElement(), (String)"org.springframework.cache.interceptor.CacheResolver");
        SpringCacheableComponentsInspection.checkBeanPointerResolve((ProblemsHolder)holder, cacheable.getKeyGeneratorElement(), (String)"org.springframework.cache.interceptor.KeyGenerator");
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringCacheableComponentsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection", "getShortName"));
        }
        return "SpringCacheableComponentsInspection";
    }
}

