/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet outer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/converters/SpringCompletionContributor", "fillCompletionVariants"));
        }
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "com/intellij/spring/model/converters/SpringCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getCompletionType() != CompletionType.SMART) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/converters/SpringCompletionContributor", "lambda$fillCompletionVariants$0"));
            }
            if (outer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "com/intellij/spring/model/converters/SpringCompletionContributor", "lambda$fillCompletionVariants$0"));
            }
            GenericDomValueReference reference = SpringCompletionContributor.getReference(parameters);
            if (reference == null) {
                return;
            }
            Collection variants = ((SpringBeanResolveConverter)reference.getConverter()).getVariants(reference.getConvertContext());
            for (SpringBeanPointer variant : variants) {
                LookupElement element = SpringConverterUtil.createCompletionVariant((SpringBeanPointer)variant);
                if (element == null) continue;
                outer.addElement(element);
            }
        });
    }

    @Nullable
    private static GenericDomValueReference getReference(CompletionParameters parameters) {
        PsiReference[] references;
        if (!(parameters.getPosition() instanceof XmlToken)) {
            return null;
        }
        for (PsiReference psiReference : references = SpringCompletionContributor.getReferences(parameters)) {
            Converter converter;
            if (!(psiReference instanceof GenericDomValueReference) || !((converter = ((GenericDomValueReference)psiReference).getConverter()) instanceof SpringBeanResolveConverter)) continue;
            return (GenericDomValueReference)psiReference;
        }
        return null;
    }

    private static PsiReference[] getReferences(CompletionParameters parameters) {
        PsiElement psiElement = parameters.getPosition().getParent();
        return psiElement instanceof XmlText ? psiElement.getParent().getReferences() : psiElement.getReferences();
    }
}

