/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.context.Filter;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.spring.model.xml.context.Type;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ContextComponentScanInconsistencyInspection
extends SpringBeanInspectionBase {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        List packagesScanBeans = DomUtil.getDefinedChildrenOfType((DomElement)domFileElement.getRootElement(), SpringBeansPackagesScanBean.class, (boolean)true, (boolean)false);
        for (SpringBeansPackagesScanBean componentScan : packagesScanBeans) {
            ContextComponentScanInconsistencyInspection.checkComponentScan(componentScan, holder);
        }
    }

    private static void checkComponentScan(@NotNull SpringBeansPackagesScanBean componentScan, @NotNull DomElementAnnotationHolder holder) {
        if (componentScan == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentScan", "com/intellij/spring/model/highlighting/ContextComponentScanInconsistencyInspection", "checkComponentScan"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/ContextComponentScanInconsistencyInspection", "checkComponentScan"));
        }
        for (Filter filter : componentScan.getExcludeFilters()) {
            ContextComponentScanInconsistencyInspection.checkFilterType(filter, holder);
        }
        for (Filter filter : componentScan.getIncludeFilters()) {
            ContextComponentScanInconsistencyInspection.checkFilterType(filter, holder);
        }
    }

    private static void checkFilterType(@NotNull Filter filter, @NotNull DomElementAnnotationHolder holder) {
        Object value;
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/spring/model/highlighting/ContextComponentScanInconsistencyInspection", "checkFilterType"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/ContextComponentScanInconsistencyInspection", "checkFilterType"));
        }
        Type type = (Type)filter.getType().getValue();
        if (type != null && type == Type.ANNOTATION && (value = filter.getExpression().getValue()) instanceof PsiClass && !((PsiClass)value).isAnnotationType()) {
            holder.createProblem((DomElement)filter.getExpression(), SpringBundle.message("ContextComponentScanInconsistencyInspection.annotation.is.expected.here", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("ContextComponentScanInconsistencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/ContextComponentScanInconsistencyInspection", "getShortName"));
        }
        return "ContextComponentScanInconsistencyInspection";
    }
}

