/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.factories.SpringFactoryBeansManagerImpl;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FactoryMethodInspection
extends SpringBeanInspectionBase {
    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringFactoryMethodInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/FactoryMethodInspection", "getShortName"));
        }
        return "SpringFactoryMethodInspection";
    }

    protected void checkBean(SpringBean springBean, Beans beans, DomElementAnnotationHolder holder, XmlSpringModel model) {
        GenericAttributeValue factoryMethodAttribute = springBean.getFactoryMethod();
        if (!DomUtil.hasXml((DomElement)factoryMethodAttribute)) {
            return;
        }
        PsiMethod factoryMethod = (PsiMethod)factoryMethodAttribute.getValue();
        if (factoryMethod != null) {
            boolean isStatic = factoryMethod.hasModifierProperty("static");
            SpringBeanPointer factoryBean = (SpringBeanPointer)springBean.getFactoryBean().getValue();
            if (!isStatic && factoryBean == null) {
                holder.createProblem((DomElement)factoryMethodAttribute, SpringBundle.message("method.must.be.static", factoryMethod.getName()), new LocalQuickFix[0]);
            } else if (isStatic && factoryBean != null) {
                holder.createProblem((DomElement)factoryMethodAttribute, SpringBundle.message("method.must.not.be.static", factoryMethod.getName()), new LocalQuickFix[0]);
            }
            if (!SpringFactoryBeansManagerImpl.hasFactoryReturnType(factoryMethod)) {
                holder.createProblem((DomElement)factoryMethodAttribute, SpringBundle.message("method.cannot.instantiate.bean", factoryMethod.getName()), new LocalQuickFix[0]);
            }
        }
    }
}

