/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.wrappers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.wrappers.ModelType;
import com.intellij.spring.model.wrappers.WScope;
import com.intellij.spring.model.wrappers.WSpringDependency;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class WModel {
    @NotNull
    public final String name;
    @NotNull
    public final ModelType type;
    @NotNull
    public final ArrayList<WSpringDependency> dependencies;
    @NotNull
    private final WScope scope;

    public WModel(@NotNull String name, @NotNull ModelType type, @NotNull WScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/wrappers/WModel", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/wrappers/WModel", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/wrappers/WModel", "<init>"));
        }
        this.dependencies = new ArrayList();
        this.name = name;
        this.type = type;
        this.scope = scope;
    }

    public WModel(@NotNull LocalModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/wrappers/WModel", "<init>"));
        }
        this.dependencies = new ArrayList();
        if (model instanceof LocalXmlModel) {
            this.name = WModel.getLocalXmlModelName((LocalXmlModel)model);
            this.type = ModelType.XML;
        } else if (model instanceof LocalAnnotationModel) {
            this.name = ((PsiClass)((LocalAnnotationModel)model).getConfig()).getQualifiedName();
            this.type = ModelType.ANNO;
        } else {
            throw new IllegalArgumentException(String.format("Can't get model type for model with class '%s'", model.getClass()));
        }
        this.scope = WModel.getScope(model);
    }

    public static String getLocalXmlModelName(@NotNull LocalXmlModel model) {
        VirtualFile projectBasePath;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/wrappers/WModel", "getLocalXmlModelName"));
        }
        VirtualFile absolutePath = ((XmlFile)model.getConfig()).getVirtualFile();
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)absolutePath, (VirtualFile)(projectBasePath = model.getModule().getProject().getBaseDir()));
        return relativePath != null ? relativePath : absolutePath.getPath();
    }

    private static WScope getScope(@NotNull LocalModel model) {
        VirtualFile file;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/wrappers/WModel", "getScope"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)model.getModule().getProject()).getFileIndex();
        if (index.isInSourceContent(file = model.getConfig().getContainingFile().getVirtualFile())) {
            return WScope.SOURCE;
        }
        if (index.isInTestSourceContent(file)) {
            return WScope.TEST;
        }
        if (index.isInLibrarySource(file) || index.isInLibraryClasses(file)) {
            return WScope.LIBRARY;
        }
        return WScope.UNKNOWN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WModel model = (WModel)o;
        if (!this.name.equals(model.name)) {
            return false;
        }
        if (this.type != model.type) {
            return false;
        }
        return this.dependencies.equals(model.dependencies);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.dependencies.hashCode();
        return result;
    }
}

