/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.references.SpringQualifierReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SpringQualifierNameReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiLiteralExpression literalExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/SpringQualifierNameReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/SpringQualifierNameReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteralExpression && (literalExpression = (PsiLiteralExpression)element).getValue() instanceof String) {
            PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
            if (psiModifierListOwner instanceof PsiClass) {
                final PsiAnnotation qualifierAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
                if (qualifierAnnotation != null) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element){

                        public PsiElement resolve() {
                            return qualifierAnnotation;
                        }

                        @NotNull
                        public Object[] getVariants() {
                            if (EMPTY_ARRAY == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierNameReferenceProvider$1", "getVariants"));
                            }
                            return EMPTY_ARRAY;
                        }
                    }};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierNameReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            } else {
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringQualifierReference(literalExpression)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierNameReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringQualifierNameReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

