/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.DefineInCommentIntention;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import org.jetbrains.annotations.NotNull;

public abstract class DefineImplicitVariableIntention
extends DefineInCommentIntention {
    public DefineImplicitVariableIntention(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/velocity/inspections/DefineImplicitVariableIntention", "<init>"));
        }
        super(text, VelocityBundle.message("add.implicit.variable.fix.name", new Object[0]));
    }

    @Override
    protected void prepareTemplate(@NotNull Template template, @NotNull PsiElement element, String relativePath, @NotNull PsiFile fileToInsertComment) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/velocity/inspections/DefineImplicitVariableIntention", "prepareTemplate"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/DefineImplicitVariableIntention", "prepareTemplate"));
        }
        if (fileToInsertComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToInsertComment", "com/intellij/velocity/inspections/DefineImplicitVariableIntention", "prepareTemplate"));
        }
        String varName = element.getText();
        assert (varName != null);
        MacroCallNode typeExpression = new MacroCallNode((Macro)new CompleteSmartMacro());
        template.addTextSegment("#* @vtlvariable name=\"" + varName + "\" type=\"");
        template.addVariable("PATH", (Expression)typeExpression, (Expression)typeExpression, true);
        String fileRef = relativePath != null ? " file=\"" + relativePath + "\"" : "";
        template.addTextSegment("\"" + fileRef + " *#\n");
        template.addEndVariable();
    }

    @Override
    protected boolean isAvailable(@NotNull VtlReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/velocity/inspections/DefineImplicitVariableIntention", "isAvailable"));
        }
        return !(ref.getParent() instanceof VtlMacroCall) && !ref.hasQualifier();
    }

    public static class ModuleWide
    extends DefineImplicitVariableIntention {
        public ModuleWide() {
            super(VelocityBundle.message("add.implicit.variable.fix.name.module.wide", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineImplicitVariableIntention$ModuleWide", "invoke"));
            }
            this.chooseTargetFile(file, editor, false);
        }
    }

    public static class LocalExternal
    extends DefineImplicitVariableIntention {
        public LocalExternal() {
            super(VelocityBundle.message("add.implicit.variable.fix.name.external", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineImplicitVariableIntention$LocalExternal", "invoke"));
            }
            this.chooseTargetFile(file, editor, true);
        }
    }

    public static class Local
    extends DefineImplicitVariableIntention {
        public Local() {
            super(VelocityBundle.message("add.implicit.variable.fix.name.local", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineImplicitVariableIntention$Local", "invoke"));
            }
            this.defineInComment(editor, file, file, false);
        }
    }
}

