/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.files.VtlFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlLightVariable
extends FakePsiElement
implements VtlVariable {
    private final PsiType myType;
    private final String name;
    private final PsiElement parent;

    public VtlLightVariable(@NotNull String name, @NotNull VtlFile parent, @NotNull String typeText) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/VtlLightVariable", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/velocity/psi/VtlLightVariable", "<init>"));
        }
        if (typeText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeText", "com/intellij/velocity/psi/VtlLightVariable", "<init>"));
        }
        this.name = name;
        this.parent = parent;
        this.myType = VtlLightVariable.createType(parent, typeText);
    }

    private static PsiType createType(PsiElement parent, String fqnClassName) {
        try {
            return JavaPsiFacade.getInstance((Project)parent.getProject()).getElementFactory().createTypeFromText(fqnClassName, parent);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{VtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlLightVariable", "getUseScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.parent;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlLightVariable", "getNavigationElement"));
        }
        return psiElement;
    }

    @Override
    public PsiType getPsiType() {
        return this.myType;
    }

    @Override
    @Nullable
    public PsiComment getDocComment() {
        return null;
    }

    public PsiElement getParent() {
        return this.parent;
    }
}

