/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.lang.ASTNode;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlCompositeElement;
import com.intellij.velocity.psi.directives.VtlDirective;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlDirectiveImpl
extends VtlCompositeElement
implements VtlDirective {
    @NotNull
    private final String myPresentableName;
    private final boolean myNeedsClosing;

    public VtlDirectiveImpl(@NotNull ASTNode node, @NotNull String presentableName, boolean needsClosing) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/directives/VtlDirectiveImpl", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/velocity/psi/directives/VtlDirectiveImpl", "<init>"));
        }
        super(node);
        this.myPresentableName = presentableName;
        this.myNeedsClosing = needsClosing;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/VtlDirectiveImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    public int getFoldingStartOffset() {
        return this.getNode().getTextRange().getStartOffset() + this.myPresentableName.length() + 1;
    }

    @Override
    public int getFoldingEndOffset() {
        return this.getNode().getTextRange().getEndOffset() - (this.needsClosing() ? "#end".length() : 0);
    }

    @Override
    public boolean needsClosing() {
        return this.myNeedsClosing;
    }

    @Nullable
    public VtlArgumentList getArgumentList() {
        return (VtlArgumentList)((Object)this.findChildByClass(VtlArgumentList.class));
    }
}

