/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlCallExpression;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlDirective;
import org.jetbrains.annotations.NotNull;

public class VtlMacroCall
extends VtlCallExpression
implements VtlDirective {
    public VtlMacroCall(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getMacroName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/VtlMacroCall", "getPresentableName"));
        }
        return string;
    }

    private String getMacroName() {
        PsiElement child = this.findChildByType(VtlCompositeElementTypes.REFERENCE_EXPRESSION);
        return child != null ? child.getText() : "";
    }

    @Override
    public int getFoldingStartOffset() {
        return this.getNode().getTextRange().getStartOffset() + this.getPresentableName().length() + 1;
    }

    @Override
    public int getFoldingEndOffset() {
        return this.getNode().getTextRange().getEndOffset();
    }

    @Override
    public boolean needsClosing() {
        return false;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/velocity/psi/directives/VtlMacroCall", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/directives/VtlMacroCall", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/velocity/psi/directives/VtlMacroCall", "processDeclarations"));
        }
        String macroName = this.getMacroName();
        if (PsiUtil.isAtLeast17(this) && StringUtil.isNotEmpty((String)macroName) && !processor.execute((PsiElement)new FixedNameVariable((PsiElement)this, macroName, true), state)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    public VtlExpression[] getArguments() {
        VtlArgumentList argList = (VtlArgumentList)((Object)this.findChildByClass(VtlArgumentList.class));
        if (argList == null) {
            if (VtlExpression.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/VtlMacroCall", "getArguments"));
            }
            return VtlExpression.EMPTY_ARRAY;
        }
        VtlExpression[] vtlExpressionArray = argList.getArguments();
        if (vtlExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/VtlMacroCall", "getArguments"));
        }
        return vtlExpressionArray;
    }
}

