/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCallExpressionTypeCalculator;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class DefaultCallExpressionTypeCalculator
extends GrCallExpressionTypeCalculator {
    private static final Logger LOG = Logger.getInstance(DefaultCallExpressionTypeCalculator.class);
    private static final Set<String> CLOSURE_METHODS = new HashSet();

    @Override
    public PsiType calculateReturnType(@NotNull GrMethodCall callExpression, GroovyResolveResult[] resolveResults) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/DefaultCallExpressionTypeCalculator", "calculateReturnType"));
        }
        GrExpression invoked = callExpression.getInvokedExpression();
        if (invoked instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)invoked;
            PsiManager manager = callExpression.getManager();
            PsiType result = null;
            for (GroovyResolveResult resolveResult : resolveResults) {
                PsiType returnType = DefaultCallExpressionTypeCalculator.calculateReturnTypeInner(callExpression, refExpr, resolveResult);
                if (returnType == null) {
                    return null;
                }
                PsiType nonVoid = PsiType.VOID.equals((Object)returnType) && !PsiUtil.isCompileStatic(callExpression) ? PsiType.NULL : returnType;
                PsiType normalized = nonVoid instanceof GrLiteralClassType ? nonVoid : TypesUtil.substituteAndNormalizeType(nonVoid, resolveResult.getSubstitutor(), resolveResult.getSpreadState(), callExpression);
                LOG.assertTrue(normalized != null, (Object)("return type: " + returnType + "; substitutor: " + resolveResult.getSubstitutor()));
                if (result == null || normalized.isAssignableFrom(result)) {
                    result = normalized;
                    continue;
                }
                if (result.isAssignableFrom(normalized)) continue;
                result = TypesUtil.getLeastUpperBound(result, normalized, manager);
            }
            return result;
        }
        return DefaultCallExpressionTypeCalculator.extractReturnTypeFromType(invoked.getType(), false, callExpression);
    }

    @Nullable
    private static PsiType calculateReturnTypeInner(GrMethodCall callExpression, GrReferenceExpression refExpr, GroovyResolveResult resolveResult) {
        PsiElement resolved = resolveResult.getElement();
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (resolveResult.isInvokedOnProperty()) {
                PsiType propertyType = PsiUtil.getSmartReturnType(method);
                return DefaultCallExpressionTypeCalculator.extractReturnTypeFromType(propertyType, true, callExpression);
            }
            PsiType closureReturnType = DefaultCallExpressionTypeCalculator.getClosureMethodsReturnType(callExpression, refExpr, method);
            if (closureReturnType != null) {
                return closureReturnType;
            }
            PsiType smartReturnType = PsiUtil.getSmartReturnType(method);
            return smartReturnType;
        }
        if (resolved instanceof GrVariable) {
            PsiType refType = refExpr.getType();
            PsiType type = (refType = TypesUtil.boxPrimitiveType(refType, callExpression.getManager(), callExpression.getResolveScope())) == null ? ((GrVariable)resolved).getTypeGroovy() : refType;
            return DefaultCallExpressionTypeCalculator.extractReturnTypeFromType(type, false, callExpression);
        }
        return null;
    }

    @Nullable
    private static PsiType extractReturnTypeFromType(PsiType type, boolean returnTypeIfFail, GrMethodCall callExpression) {
        PsiType returnType;
        Object object = returnType = returnTypeIfFail ? type : null;
        if (type instanceof GrClosureType) {
            returnType = GrClosureSignatureUtil.getReturnType(((GrClosureType)type).getSignature(), callExpression);
        } else if (TypesUtil.isPsiClassTypeToClosure(type)) {
            assert (type instanceof PsiClassType);
            PsiType[] parameters = ((PsiClassType)type).getParameters();
            if (parameters.length == 1) {
                returnType = parameters[0];
            }
        } else if (type instanceof PsiClassType) {
            GrExpression invoked = callExpression.getInvokedExpression();
            GroovyResolveResult[] calls = ResolveUtil.getMethodCandidates(type, "call", (PsiElement)(invoked != null ? invoked : callExpression), PsiUtil.getArgumentTypes(invoked, false));
            returnType = null;
            PsiManager manager = callExpression.getManager();
            for (GroovyResolveResult call : calls) {
                PsiType substituted = ResolveUtil.extractReturnTypeFromCandidate(call, callExpression, PsiUtil.getArgumentTypes(invoked, true));
                returnType = TypesUtil.getLeastUpperBoundNullable(returnType, substituted, manager);
            }
        }
        return returnType;
    }

    @Nullable
    private static PsiType getClosureMethodsReturnType(GrMethodCall callExpression, GrReferenceExpression refExpr, PsiMethod resolved) {
        PsiClass clazz = resolved.getContainingClass();
        if (clazz == null || !"groovy.lang.Closure".equals(clazz.getQualifiedName())) {
            return null;
        }
        if (!CLOSURE_METHODS.contains(resolved.getName())) {
            return null;
        }
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType qType = qualifier.getType();
        if (!(qType instanceof GrClosureType)) {
            return null;
        }
        if ("call".equals(resolved.getName())) {
            return GrClosureSignatureUtil.getReturnType(((GrClosureType)qType).getSignature(), callExpression);
        }
        if ("curry".equals(resolved.getName()) || "trampoline".equals(resolved.getName())) {
            return ((GrClosureType)qType).curry(PsiUtil.getArgumentTypes(refExpr, false), 0, callExpression);
        }
        if ("memoize".equals(resolved.getName())) {
            return qType;
        }
        if ("rcurry".equals(resolved.getName())) {
            return ((GrClosureType)qType).curry(PsiUtil.getArgumentTypes(refExpr, false), -1, callExpression);
        }
        if ("ncurry".equals(resolved.getName())) {
            Object[] argTypes;
            Object value;
            GrExpression first;
            GrArgumentList argList = callExpression.getArgumentList();
            GrExpression[] arguments = argList.getExpressionArguments();
            if (arguments.length > 0 && (first = arguments[0]) instanceof GrLiteral && (value = ((GrLiteral)first).getValue()) instanceof Integer && (argTypes = PsiUtil.getArgumentTypes(refExpr, false)) != null) {
                return ((GrClosureType)qType).curry((PsiType[])ArrayUtil.remove((Object[])argTypes, (int)0), (Integer)value, callExpression);
            }
            return qType;
        }
        return null;
    }

    static {
        CLOSURE_METHODS.add("call");
        CLOSURE_METHODS.add("curry");
        CLOSURE_METHODS.add("ncurry");
        CLOSURE_METHODS.add("rcurry");
        CLOSURE_METHODS.add("memoize");
        CLOSURE_METHODS.add("trampoline");
    }
}

