/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public class GroovyRunConfigurationEditor
extends SettingsEditor<GroovyScriptRunConfiguration>
implements PanelWithAnchor {
    private JPanel myMainPanel;
    private LabeledComponent<TextFieldWithBrowseButton> myScriptPathComponent;
    private CommonJavaParametersPanel myCommonJavaParametersPanel;
    private LabeledComponent<ModulesComboBox> myModulesComboBoxComponent;
    private JrePathEditor myJrePathEditor;
    private JCheckBox myDebugCB;
    private JCheckBox myAddClasspathCB;
    private JComponent myAnchor;

    public GroovyRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor", "<init>"));
        }
        this.$$$setupUI$$$();
        final TextFieldWithBrowseButton scriptPath = (TextFieldWithBrowseButton)this.myScriptPathComponent.getComponent();
        scriptPath.addBrowseFolderListener("Script Path", "Specify path to script", project, FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)GroovyFileType.GROOVY_FILE_TYPE));
        ModulesComboBox modulesComboBox = (ModulesComboBox)this.myModulesComboBoxComponent.getComponent();
        modulesComboBox.addActionListener(e -> this.myCommonJavaParametersPanel.setModuleContext(modulesComboBox.getSelectedModule()));
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Function0 productionOnly = () -> {
            VirtualFile script = ScriptFileUtil.findScriptFileByPath((String)scriptPath.getText());
            return script != null && !fileIndex.isInTestSourceContent(script);
        };
        this.myJrePathEditor.setDefaultJreSelector((DefaultJreSelector)new DefaultJreSelector.SdkFromModuleDependencies(modulesComboBox, productionOnly){

            public void addChangeListener(final @NotNull Runnable listener) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor$1", "addChangeListener"));
                }
                super.addChangeListener(listener);
                ((JTextField)scriptPath.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(DocumentEvent e) {
                        listener.run();
                    }
                });
            }
        });
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myScriptPathComponent, this.myCommonJavaParametersPanel, this.myModulesComboBoxComponent, this.myJrePathEditor});
    }

    public void resetEditorFrom(@NotNull GroovyScriptRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor", "resetEditorFrom"));
        }
        ((TextFieldWithBrowseButton)this.myScriptPathComponent.getComponent()).setText(configuration.getScriptPath());
        this.myCommonJavaParametersPanel.reset((CommonJavaRunConfigurationParameters)configuration);
        ((ModulesComboBox)this.myModulesComboBoxComponent.getComponent()).setModules(configuration.getValidModules());
        ((ModulesComboBox)this.myModulesComboBoxComponent.getComponent()).setSelectedModule(configuration.getConfigurationModule().getModule());
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        this.myDebugCB.setSelected(configuration.isDebugEnabled());
        this.myAddClasspathCB.setSelected(configuration.isAddClasspathToTheRunner());
    }

    public void applyEditorTo(@NotNull GroovyScriptRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor", "applyEditorTo"));
        }
        configuration.setScriptPath(((TextFieldWithBrowseButton)this.myScriptPathComponent.getComponent()).getText().trim());
        this.myCommonJavaParametersPanel.applyTo((CommonJavaRunConfigurationParameters)configuration);
        configuration.setModule(((ModulesComboBox)this.myModulesComboBoxComponent.getComponent()).getSelectedModule());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setDebugEnabled(this.myDebugCB.isSelected());
        configuration.setAddClasspathToTheRunner(this.myAddClasspathCB.isSelected());
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myScriptPathComponent.setAnchor(anchor);
        this.myCommonJavaParametersPanel.setAnchor(anchor);
        this.myModulesComboBoxComponent.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JrePathEditor jrePathEditor;
        LabeledComponent labeledComponent;
        CommonJavaParametersPanel commonJavaParametersPanel;
        LabeledComponent labeledComponent2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScriptPathComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setVerifyInputWhenFocusTarget(false);
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent2.setText("Script path");
        labeledComponent2.setLabelLocation("West");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCommonJavaParametersPanel = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 10), null));
        this.myModulesComboBoxComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent.setText("Module");
        labeledComponent.setLabelLocation("West");
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 10), null));
        this.myDebugCB = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/GroovyBundle").getString("debug.option"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddClasspathCB = jCheckBox = new JCheckBox();
        jCheckBox.setText("Add module classpath to the runner");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

