/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenEmbedderWrapper
extends RemoteObjectWrapper<MavenServerEmbedder> {
    private Customization myCustomization;

    public MavenEmbedderWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        super(parent);
    }

    @Override
    protected synchronized void onWrappeeCreated() throws RemoteException {
        super.onWrappeeCreated();
        if (this.myCustomization != null) {
            this.doCustomize();
        }
    }

    public void customizeForResolve(MavenConsole console, MavenProgressIndicator indicator) {
        this.setCustomization(console, indicator, null, false, false);
        this.perform(new RemoteObjectWrapper.Retriable<Object>(){

            @Override
            public Object execute() throws RemoteException {
                MavenEmbedderWrapper.this.doCustomize();
                return null;
            }
        });
    }

    public void customizeForResolve(MavenWorkspaceMap workspaceMap, MavenConsole console, MavenProgressIndicator indicator, boolean alwaysUpdateSnapshot) {
        this.setCustomization(console, indicator, workspaceMap, false, alwaysUpdateSnapshot);
        this.perform(new RemoteObjectWrapper.Retriable<Object>(){

            @Override
            public Object execute() throws RemoteException {
                MavenEmbedderWrapper.this.doCustomize();
                return null;
            }
        });
    }

    public void customizeForStrictResolve(MavenWorkspaceMap workspaceMap, MavenConsole console, MavenProgressIndicator indicator) {
        this.setCustomization(console, indicator, workspaceMap, true, false);
        this.perform(new RemoteObjectWrapper.Retriable<Object>(){

            @Override
            public Object execute() throws RemoteException {
                MavenEmbedderWrapper.this.doCustomize();
                return null;
            }
        });
    }

    public void customizeForGetVersions() {
        this.perform(new RemoteObjectWrapper.Retriable<Object>(){

            @Override
            public Object execute() throws RemoteException {
                MavenEmbedderWrapper.this.doCustomizeComponents();
                return null;
            }
        });
    }

    private synchronized void doCustomizeComponents() throws RemoteException {
        ((MavenServerEmbedder)this.getOrCreateWrappee()).customizeComponents();
    }

    private synchronized void doCustomize() throws RemoteException {
        ((MavenServerEmbedder)this.getOrCreateWrappee()).customize(this.myCustomization.workspaceMap, this.myCustomization.failOnUnresolvedDependency, this.myCustomization.console, this.myCustomization.indicator, this.myCustomization.alwaysUpdateSnapshot);
    }

    public MavenServerExecutionResult resolveProject(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveProject"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveProject"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveProject"));
        }
        return this.resolveProject(Collections.singleton(file), activeProfiles, inactiveProfiles).iterator().next();
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProject(final @NotNull Collection<VirtualFile> files, final @NotNull Collection<String> activeProfiles, final @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveProject"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveProject"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveProject"));
        }
        Collection<MavenServerExecutionResult> collection = this.perform(new RemoteObjectWrapper.RetriableCancelable<Collection<MavenServerExecutionResult>>(){

            @Override
            public Collection<MavenServerExecutionResult> execute() throws RemoteException, MavenServerProcessCanceledException {
                List ioFiles = ContainerUtil.map((Collection)files, file -> new File(file.getPath()));
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).resolveProject((Collection)ioFiles, activeProfiles, inactiveProfiles);
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveProject"));
        }
        return collection;
    }

    @Nullable
    public String evaluateEffectivePom(final @NotNull VirtualFile file, final @NotNull Collection<String> activeProfiles, final @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "evaluateEffectivePom"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "evaluateEffectivePom"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "evaluateEffectivePom"));
        }
        return this.perform(new RemoteObjectWrapper.RetriableCancelable<String>(){

            @Override
            public String execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).evaluateEffectivePom(new File(file.getPath()), new ArrayList(activeProfiles), new ArrayList(inactiveProfiles));
            }
        });
    }

    @NotNull
    public MavenArtifact resolve(final @NotNull MavenArtifactInfo info, final @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolve"));
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteRepositories", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolve"));
        }
        MavenArtifact mavenArtifact = this.perform(new RemoteObjectWrapper.RetriableCancelable<MavenArtifact>(){

            @Override
            public MavenArtifact execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).resolve(info, remoteRepositories);
            }
        });
        if (mavenArtifact == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolve"));
        }
        return mavenArtifact;
    }

    @NotNull
    public List<MavenArtifact> resolveTransitively(final @NotNull List<MavenArtifactInfo> artifacts, final @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveTransitively"));
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteRepositories", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveTransitively"));
        }
        List<MavenArtifact> list = this.perform(new RemoteObjectWrapper.RetriableCancelable<List<MavenArtifact>>(){

            @Override
            public List<MavenArtifact> execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).resolveTransitively(artifacts, remoteRepositories);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolveTransitively"));
        }
        return list;
    }

    @NotNull
    public List<String> retrieveVersions(final @NotNull String groupId, final @NotNull String artifactId, final @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "retrieveVersions"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "retrieveVersions"));
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteRepositories", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "retrieveVersions"));
        }
        List<String> list = this.perform(new RemoteObjectWrapper.RetriableCancelable<List<String>>(){

            @Override
            public List<String> execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).retrieveAvailableVersions(groupId, artifactId, remoteRepositories);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "retrieveVersions"));
        }
        return list;
    }

    public Collection<MavenArtifact> resolvePlugin(@NotNull MavenPlugin plugin, @NotNull List<MavenRemoteRepository> repositories, @NotNull NativeMavenProjectHolder nativeMavenProject, boolean transitive) throws MavenProcessCanceledException {
        int id;
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolvePlugin"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolvePlugin"));
        }
        if (nativeMavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeMavenProject", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "resolvePlugin"));
        }
        try {
            id = nativeMavenProject.getId();
        }
        catch (RemoteException e) {
            return Collections.emptyList();
        }
        try {
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).resolvePlugin(plugin, repositories, id, transitive);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return Collections.emptyList();
        }
        catch (MavenServerProcessCanceledException e) {
            throw new MavenProcessCanceledException();
        }
    }

    public MavenModel readModel(final File file) throws MavenProcessCanceledException {
        return this.perform(new RemoteObjectWrapper.RetriableCancelable<MavenModel>(){

            @Override
            public MavenModel execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).readModel(file);
            }
        });
    }

    @NotNull
    public MavenServerExecutionResult execute(final @NotNull VirtualFile file, final @NotNull Collection<String> activeProfiles, final @NotNull Collection<String> inactiveProfiles, final @NotNull List<String> goals) throws MavenProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        if (goals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goals", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        MavenServerExecutionResult mavenServerExecutionResult = this.perform(new RemoteObjectWrapper.RetriableCancelable<MavenServerExecutionResult>(){

            @Override
            public MavenServerExecutionResult execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).execute(new File(file.getPath()), activeProfiles, inactiveProfiles, goals, Collections.emptyList(), false, false);
            }
        });
        if (mavenServerExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        return mavenServerExecutionResult;
    }

    @NotNull
    public MavenServerExecutionResult execute(final @NotNull VirtualFile file, final @NotNull Collection<String> activeProfiles, final @NotNull Collection<String> inactiveProfiles, final @NotNull List<String> goals, final @NotNull List<String> selectedProjects, final boolean alsoMake, final boolean alsoMakeDependents) throws MavenProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        if (goals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goals", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        if (selectedProjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedProjects", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        MavenServerExecutionResult mavenServerExecutionResult = this.perform(new RemoteObjectWrapper.RetriableCancelable<MavenServerExecutionResult>(){

            @Override
            public MavenServerExecutionResult execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).execute(new File(file.getPath()), activeProfiles, inactiveProfiles, goals, selectedProjects, alsoMake, alsoMakeDependents);
            }
        });
        if (mavenServerExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenEmbedderWrapper", "execute"));
        }
        return mavenServerExecutionResult;
    }

    public void reset() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.reset();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
        this.resetCustomization();
    }

    public void release() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.release();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
        this.resetCustomization();
    }

    public void clearCaches() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.clearCaches();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public void clearCachesFor(MavenId projectId) {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.clearCachesFor(projectId);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    private synchronized void setCustomization(MavenConsole console, MavenProgressIndicator indicator, MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshot) {
        this.resetCustomization();
        this.myCustomization = new Customization(MavenServerManager.wrapAndExport(console), MavenServerManager.wrapAndExport(indicator), workspaceMap, failOnUnresolvedDependency, alwaysUpdateSnapshot);
    }

    private synchronized void resetCustomization() {
        if (this.myCustomization == null) {
            return;
        }
        try {
            UnicastRemoteObject.unexportObject((Remote)this.myCustomization.console, true);
        }
        catch (NoSuchObjectException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        try {
            UnicastRemoteObject.unexportObject((Remote)this.myCustomization.indicator, true);
        }
        catch (NoSuchObjectException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        this.myCustomization = null;
    }

    private static class Customization {
        private final MavenServerConsole console;
        private final MavenServerProgressIndicator indicator;
        private final MavenWorkspaceMap workspaceMap;
        private final boolean failOnUnresolvedDependency;
        private final boolean alwaysUpdateSnapshot;

        private Customization(MavenServerConsole console, MavenServerProgressIndicator indicator, MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshot) {
            this.console = console;
            this.indicator = indicator;
            this.workspaceMap = workspaceMap;
            this.failOnUnresolvedDependency = failOnUnresolvedDependency;
            this.alwaysUpdateSnapshot = alwaysUpdateSnapshot;
        }
    }
}

