/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.model.highlighting.jam.AbstractSpringJavaConfigInspection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringDataRepositoriesInspection
extends AbstractSpringJavaConfigInspection {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkFile"));
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module == null) {
                return null;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly, module);
            List problemDescriptors = holder.getResults();
            return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFile", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkJavaFile"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkJavaFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkJavaFile"));
        }
        if (!SpringDataUtil.hasSpringDataSupport(module.getProject())) {
            return;
        }
        super.checkJavaFile(javaFile, holder, isOnTheFly, module);
    }

    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkClass"));
        }
        if (!SpringDataUtil.isRepository(aClass)) {
            return;
        }
        this.checkRepositoryClass(aClass, holder, module);
        Pair<PsiClass, ? extends PsiType> typePair = SpringDataUtil.substituteRepositoryTypes(aClass);
        if (typePair != null) {
            for (PsiMethod psiMethod : aClass.getMethods()) {
                if (!SpringDataUtil.isQueryMethod(psiMethod)) continue;
                this.checkRepositoryMethod(holder, aClass, psiMethod, module, typePair);
            }
        }
    }

    protected void checkRepositoryClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkRepositoryClass"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkRepositoryClass"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkRepositoryClass"));
        }
    }

    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, PsiClass repositoryClass, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkRepositoryMethod"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkRepositoryMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkRepositoryMethod"));
        }
        if (typePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePair", "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection", "checkRepositoryMethod"));
        }
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType, String ... classes) {
        for (String aClass : classes) {
            PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)aClass, (int)0, (boolean)false);
            if (psiType == null) continue;
            return psiType;
        }
        return null;
    }
}

