/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.nodes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.commons.util.nodes.PropertyNode;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SortNode
extends PropertyNode {
    private Direction myDirection;
    private String myPropertyName;

    public SortNode(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/data/commons/util/nodes/SortNode", "<init>"));
        }
        super(expression);
        this.myDirection = Direction.DEFAULT;
        this.myPropertyName = "";
        for (Direction direction : Direction.ALL) {
            String name = direction.getName();
            if (!expression.endsWith(name)) continue;
            this.myDirection = direction;
            this.myPropertyName = StringUtil.decapitalize((String)(StringUtil.isEmpty((String)name) ? expression : expression.substring(0, expression.indexOf(name))));
            break;
        }
    }

    public Direction getDirection() {
        return this.myDirection;
    }

    @Override
    public String getPropertyName() {
        return this.myPropertyName;
    }

    @Override
    public boolean isDefaultKeyword() {
        return this.myDirection == Direction.DEFAULT;
    }

    @Override
    public Set<String> getPropertyKeywords() {
        HashSet strings = new HashSet();
        strings.add((Object)Direction.ASC.getName());
        strings.add((Object)Direction.DESC.getName());
        return strings;
    }

    @Override
    @NotNull
    public String getKeyword() {
        String string = this.myDirection.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/util/nodes/SortNode", "getKeyword"));
        }
        return string;
    }

    public static enum Direction {
        ASC("Asc"),
        DESC("Desc"),
        DEFAULT("");

        public static Direction[] ALL;
        private String myName;

        private Direction(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/data/commons/util/nodes/SortNode$Direction", "<init>"));
            }
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        static {
            ALL = new Direction[]{ASC, DESC, DEFAULT};
        }
    }
}

