/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.CompilerRunnerUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerServicesFacadeImpl;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinLogger;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0002H\u0015J\u0012\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JJ\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u0010)\u001a\u00020&J.\u0010*\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010-\u001a\u00020&J4\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020&2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u00101\u001a\u00020#H\u0002J\u0018\u00102\u001a\u00020 2\u0006\u0010-\u001a\u00020&2\u0006\u00101\u001a\u00020,H\u0002J\u001b\u00103\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u00104J\u001f\u00105\u001a\u00020 2\u0006\u00101\u001a\u00020\u00052\f\u00106\u001a\b\u0012\u0004\u0012\u00020 07H\u0082\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/JpsKotlinCompilerRunner;", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner;", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "()V", "compilerSettings", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "getLog", "()Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "compileWithDaemon", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "compilerClassName", "", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "compileWithDaemonOrFallback", "fallbackCompileStrategy", "getDaemonConnection", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$DaemonConnection;", "getReturnCodeFromObject", "rc", "", "reportCategories", "", "", "verbose", "", "(Z)[Ljava/lang/Integer;", "reportSeverity", "runK2JsCompiler", "", "commonArguments", "k2jsArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "sourceFiles", "", "Ljava/io/File;", "libraries", "", "outputFile", "runK2JvmCompiler", "k2jvmArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "moduleFile", "setupK2JsArguments", "_outputFile", "_libraries", "settings", "setupK2JvmArguments", "withAdditionalCompilerArgs", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)[Ljava/lang/String;", "withCompilerSettings", "fn", "Lkotlin/Function0;", "Companion", "jps-plugin"})
public final class JpsKotlinCompilerRunner
extends KotlinCompilerRunner<JpsCompilerEnvironment> {
    @NotNull
    private final KotlinLogger log;
    private CompilerSettings compilerSettings;
    private static volatile KotlinCompilerRunner.DaemonConnection jpsDaemonConnection;
    public static final Companion Companion;

    @Override
    @NotNull
    protected KotlinLogger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withCompilerSettings(CompilerSettings settings, Function0<Unit> fn) {
        CompilerSettings old = this.compilerSettings;
        try {
            this.compilerSettings = settings;
            fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.compilerSettings = old;
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runK2JvmCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JVMCompilerArguments k2jvmArguments, @NotNull CompilerSettings compilerSettings, @NotNull JpsCompilerEnvironment environment, @NotNull File moduleFile) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jvmArguments, (String)"k2jvmArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        K2JVMCompilerArguments arguments = ArgumentUtilsKt.mergeBeans(commonArguments, k2jvmArguments);
        this.setupK2JvmArguments(moduleFile, arguments);
        JpsKotlinCompilerRunner this_$iv = this;
        CompilerSettings old$iv = this_$iv.compilerSettings;
        try {
            this_$iv.compilerSettings = compilerSettings;
            this.runCompiler(this.getK2JVM_COMPILER(), arguments, (CompilerEnvironment)environment);
        }
        finally {
            this_$iv.compilerSettings = old$iv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runK2JsCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JSCompilerArguments k2jsArguments, @NotNull CompilerSettings compilerSettings, @NotNull JpsCompilerEnvironment environment, @NotNull Collection<? extends File> sourceFiles, @NotNull List<String> libraries, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jsArguments, (String)"k2jsArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        this.getLog().debug("K2JS: common arguments: " + ArgumentUtils.convertArgumentsToStringList(commonArguments));
        this.getLog().debug("K2JS: JS arguments: " + ArgumentUtils.convertArgumentsToStringList(k2jsArguments));
        K2JSCompilerArguments arguments = ArgumentUtilsKt.mergeBeans(commonArguments, k2jsArguments);
        this.getLog().debug("K2JS: merged arguments: " + ArgumentUtils.convertArgumentsToStringList(arguments));
        this.setupK2JsArguments(outputFile, sourceFiles, libraries, arguments);
        this.getLog().debug("K2JS: arguments after setup" + ArgumentUtils.convertArgumentsToStringList(arguments));
        JpsKotlinCompilerRunner this_$iv = this;
        CompilerSettings old$iv = this_$iv.compilerSettings;
        try {
            this_$iv.compilerSettings = compilerSettings;
            this.runCompiler(this.getK2JS_COMPILER(), arguments, (CompilerEnvironment)environment);
        }
        finally {
            this_$iv.compilerSettings = old$iv;
        }
    }

    @Override
    @NotNull
    protected ExitCode compileWithDaemonOrFallback(@NotNull String compilerClassName, @NotNull CommonCompilerArguments compilerArgs, @NotNull JpsCompilerEnvironment environment) {
        ExitCode exitCode;
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull((Object)compilerArgs, (String)"compilerArgs");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        environment.getMessageCollector().report(CompilerMessageSeverity.INFO, "Using kotlin-home = " + environment.getKotlinPaths().getHomePath(), CompilerMessageLocation.NO_LOCATION);
        if (DaemonParamsKt.isDaemonEnabled()) {
            ExitCode daemonExitCode = this.compileWithDaemon(compilerClassName, compilerArgs, environment);
            exitCode = daemonExitCode;
            if (exitCode == null) {
                exitCode = this.fallbackCompileStrategy(compilerArgs, compilerClassName, environment);
            }
        } else {
            exitCode = this.fallbackCompileStrategy(compilerArgs, compilerClassName, environment);
        }
        return exitCode;
    }

    @Override
    @Nullable
    protected ExitCode compileWithDaemon(@NotNull String compilerClassName, @NotNull CommonCompilerArguments compilerArgs, @NotNull JpsCompilerEnvironment environment) {
        ExitCode exitCode;
        CompileService.TargetPlatform targetPlatform;
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull((Object)compilerArgs, (String)"compilerArgs");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        String string = compilerClassName;
        if (Intrinsics.areEqual((Object)string, (Object)this.getK2JVM_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.JVM;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getK2JS_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.JS;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getK2METADATA_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.METADATA;
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown compiler type " + compilerClassName);
        }
        CompileService.TargetPlatform targetPlatform2 = targetPlatform;
        CompileService.CallResult res2 = (CompileService.CallResult)this.withDaemon((CompilerEnvironment)environment, true, (Function2)new Function2<CompileService, Integer, CompileService.CallResult<? extends Integer>>(this, compilerArgs, targetPlatform2, environment){
            final /* synthetic */ JpsKotlinCompilerRunner this$0;
            final /* synthetic */ CommonCompilerArguments $compilerArgs;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ JpsCompilerEnvironment $environment;

            @NotNull
            public final CompileService.CallResult<Integer> invoke(@NotNull CompileService daemon, int sessionId) {
                CompilationOptions compilationOptions;
                Intrinsics.checkParameterIsNotNull((Object)daemon, (String)"daemon");
                CompilerMode compilerMode = CompilerMode.JPS_COMPILER;
                boolean verbose = this.$compilerArgs.verbose;
                int n = JpsKotlinCompilerRunner.access$reportSeverity(this.this$0, verbose);
                Integer[] integerArray = JpsKotlinCompilerRunner.access$reportCategories(this.this$0, verbose);
                CompileService.TargetPlatform targetPlatform = this.$targetPlatform;
                CompilerMode compilerMode2 = compilerMode;
                CompilationOptions compilationOptions2 = compilationOptions;
                CompilationOptions compilationOptions3 = compilationOptions;
                Object[] objectArray = new Integer[0];
                compilationOptions2(compilerMode2, targetPlatform, integerArray, n, (Integer[])objectArray);
                CompilationOptions options = compilationOptions3;
                return daemon.compile(sessionId, JpsKotlinCompilerRunner.access$withAdditionalCompilerArgs(this.this$0, this.$compilerArgs), options, new JpsCompilerServicesFacadeImpl(this.$environment, 0, 2, null), null);
            }
            {
                this.this$0 = jpsKotlinCompilerRunner;
                this.$compilerArgs = commonCompilerArguments;
                this.$targetPlatform = targetPlatform;
                this.$environment = jpsCompilerEnvironment;
                super(2);
            }
        });
        Serializable serializable = res2;
        if (serializable != null && (serializable = (Integer)serializable.get()) != null) {
            Serializable serializable2 = serializable;
            int it = ((Number)serializable2).intValue();
            exitCode = this.exitCodeFromProcessExitCode(it);
        } else {
            exitCode = null;
        }
        return exitCode;
    }

    private final String[] withAdditionalCompilerArgs(CommonCompilerArguments compilerArgs) {
        Collection $receiver$iv;
        Object object;
        List allArgs = CollectionsKt.plus((Collection)ArgumentUtils.convertArgumentsToStringList(compilerArgs), (Iterable)((object = this.compilerSettings) != null && (object = ((CompilerSettings)object).additionalArguments) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()));
        Collection collection = $receiver$iv = (Collection)allArgs;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (String[])((Object[])stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] reportCategories(boolean verbose) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        ReportCategory[] reportCategoryArray;
        if (!verbose) {
            ReportCategory[] elements$iv = new ReportCategory[]{ReportCategory.COMPILER_MESSAGE, ReportCategory.EXCEPTION};
            reportCategoryArray = (ReportCategory[])((Object[])elements$iv);
        } else {
            reportCategoryArray = ReportCategory.values();
        }
        ReportCategory[] categories = reportCategoryArray;
        Object[] $i$f$arrayOf = $receiver$iv = (Object[])categories;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            ReportCategory reportCategory = (ReportCategory)item$iv$iv;
            Collection collection = destination$iv$iv;
            Integer n = it.getCode();
            collection.add(n);
        }
        $receiver$iv = (List)destination$iv$iv;
        Collection thisCollection$iv = (Collection)$receiver$iv;
        Integer[] integerArray = thisCollection$iv.toArray(new Integer[thisCollection$iv.size()]);
        if (integerArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (Integer[])((Object[])integerArray);
    }

    private final int reportSeverity(boolean verbose) {
        return !verbose ? ReportSeverity.INFO.getCode() : ReportSeverity.DEBUG.getCode();
    }

    private final ExitCode fallbackCompileStrategy(CommonCompilerArguments compilerArgs, String compilerClassName, JpsCompilerEnvironment environment) {
        this.getLog().info("Compile in-process");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(stream);
        String string = System.getProperty("compile.parallel", "false");
        if (Boolean.parseBoolean(string)) {
            System.setProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY(), "true");
        }
        Object rc = CompilerRunnerUtil.invokeExecMethod(compilerClassName, this.withAdditionalCompilerArgs(compilerArgs), environment, out);
        ExitCode exitCode = ExitCode.valueOf(this.getReturnCodeFromObject(rc));
        this.processCompilerOutput((CompilerEnvironment)environment, stream, exitCode);
        return exitCode;
    }

    private final void setupK2JvmArguments(File moduleFile, K2JVMCompilerArguments settings) {
        K2JVMCompilerArguments $receiver = settings;
        $receiver.module = moduleFile.getAbsolutePath();
        $receiver.noStdlib = true;
        $receiver.noReflect = true;
        $receiver.noJdk = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupK2JsArguments(File _outputFile, Collection<? extends File> sourceFiles, List<String> _libraries, K2JSCompilerArguments settings) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        K2JSCompilerArguments $receiver = settings;
        $receiver.noStdlib = true;
        Iterable iterable = sourceFiles;
        K2JSCompilerArguments k2JSCompilerArguments = $receiver;
        void var8_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            String string = it.getPath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        k2JSCompilerArguments.freeArgs = collection;
        $receiver.outputFile = _outputFile.getPath();
        $receiver.metaInfo = true;
        Iterable iterable2 = _libraries;
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
        $receiver.libraries = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    private final String getReturnCodeFromObject(Object rc) {
        if (rc == null) {
            return this.getINTERNAL_ERROR();
        }
        if (Intrinsics.areEqual((Object)ExitCode.class.getName(), (Object)rc.getClass().getName())) {
            return rc.toString();
        }
        throw (Throwable)new IllegalStateException("Unexpected return: " + rc);
    }

    @Override
    @NotNull
    protected synchronized KotlinCompilerRunner.DaemonConnection getDaemonConnection(@NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        if (JpsKotlinCompilerRunner.Companion.getJpsDaemonConnection() == null) {
            File libPath = CompilerRunnerUtil.getLibPath(environment.getKotlinPaths(), environment.getMessageCollector());
            File compilerPath = new File(libPath, "kotlin-compiler.jar");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId(compilerPath);
            DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
            File flagFile2 = ClientUtilsKt.makeAutodeletingFlagFile("compiler-jps-session-", new File(DaemonParamsKt.getRunFilesPathOrDefault(daemonOptions)));
            JpsKotlinCompilerRunner.Companion.setJpsDaemonConnection(this.newDaemonConnection(compilerId, flagFile2, (CompilerEnvironment)environment, daemonOptions));
        }
        KotlinCompilerRunner.DaemonConnection daemonConnection = JpsKotlinCompilerRunner.Companion.getJpsDaemonConnection();
        if (daemonConnection == null) {
            Intrinsics.throwNpe();
        }
        return daemonConnection;
    }

    public JpsKotlinCompilerRunner() {
        Logger logger = KotlinBuilder.Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"KotlinBuilder.LOG");
        this.log = new JpsKotlinLogger(logger);
    }

    static {
        Companion = new Companion(null);
    }

    @NotNull
    public static final /* synthetic */ Integer[] access$reportCategories(JpsKotlinCompilerRunner $this, boolean verbose) {
        return $this.reportCategories(verbose);
    }

    public static final /* synthetic */ int access$reportSeverity(JpsKotlinCompilerRunner $this, boolean verbose) {
        return $this.reportSeverity(verbose);
    }

    @NotNull
    public static final /* synthetic */ String[] access$withAdditionalCompilerArgs(JpsKotlinCompilerRunner $this, @NotNull CommonCompilerArguments compilerArgs) {
        return $this.withAdditionalCompilerArgs(compilerArgs);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/JpsKotlinCompilerRunner$Companion;", "", "()V", "jpsDaemonConnection", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$DaemonConnection;", "getJpsDaemonConnection", "()Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$DaemonConnection;", "setJpsDaemonConnection", "(Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$DaemonConnection;)V", "jps-plugin"})
    public static final class Companion {
        private final KotlinCompilerRunner.DaemonConnection getJpsDaemonConnection() {
            return jpsDaemonConnection;
        }

        private final void setJpsDaemonConnection(KotlinCompilerRunner.DaemonConnection daemonConnection) {
            jpsDaemonConnection = daemonConnection;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

