/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.custom;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.custom.CustomModuleComponentsDiscoverer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomComponentsDiscovererHelper {
    @NotNull
    private final Module myModule;
    private final NotNullLazyValue<Set<CachedValue<CommonSpringModel>>> myCachedModels;

    public static CustomComponentsDiscovererHelper getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper", "getInstance"));
        }
        return (CustomComponentsDiscovererHelper)ModuleServiceManager.getService((Module)module, CustomComponentsDiscovererHelper.class);
    }

    public CustomComponentsDiscovererHelper(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper", "<init>"));
        }
        this.myCachedModels = new VolatileNotNullLazyValue<Set<CachedValue<CommonSpringModel>>>(){

            @NotNull
            protected Set<CachedValue<CommonSpringModel>> compute() {
                LinkedHashSet set = ContainerUtil.newLinkedHashSet();
                for (CustomModuleComponentsDiscoverer discoverer : (CustomModuleComponentsDiscoverer[])Extensions.getExtensions(CustomModuleComponentsDiscoverer.EP_NAME)) {
                    if (!discoverer.accepts(CustomComponentsDiscovererHelper.this.myModule)) continue;
                    set.add(this.createCachedModel(discoverer));
                }
                LinkedHashSet linkedHashSet = set;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$1", "compute"));
                }
                return linkedHashSet;
            }

            private CachedValue<CommonSpringModel> createCachedModel(final @NotNull CustomModuleComponentsDiscoverer discoverer) {
                if (discoverer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "discoverer", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$1", "createCachedModel"));
                }
                return CachedValuesManager.getManager((Project)CustomComponentsDiscovererHelper.this.myModule.getProject()).createCachedValue(() -> {
                    if (discoverer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "discoverer", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$1", "lambda$createCachedModel$0"));
                    }
                    CustomComponentDiscovererBeansModel model = new CustomComponentDiscovererBeansModel(CustomComponentsDiscovererHelper.this.myModule, (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                        @NotNull
                        protected Collection<? extends SpringBeanPointer> compute() {
                            Set<SpringBeanPointer> set = BeanService.getInstance().mapSpringBeans(discoverer.getCustomComponents(CustomComponentsDiscovererHelper.this.myModule));
                            if (set == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$1$1", "compute"));
                            }
                            return set;
                        }
                    }, discoverer.getProviderName());
                    return CachedValueProvider.Result.create((Object)model, (Object[])discoverer.getDependencies(CustomComponentsDiscovererHelper.this.myModule));
                }, false);
            }
        };
        this.myModule = module;
    }

    public Collection<CommonSpringModel> getCustomModels() {
        return ContainerUtil.map((Collection)((Collection)this.myCachedModels.getValue()), CachedValue::getValue);
    }

    private static class CustomComponentDiscovererBeansModel
    extends BeansSpringModel {
        @NotNull
        private final String myProviderName;

        private CustomComponentDiscovererBeansModel(@Nullable Module module, @NotNull NotNullLazyValue<Collection<? extends SpringBeanPointer>> pointers, @NotNull String providerName) {
            if (pointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$CustomComponentDiscovererBeansModel", "<init>"));
            }
            if (providerName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerName", "com/intellij/spring/model/custom/CustomComponentsDiscovererHelper$CustomComponentDiscovererBeansModel", "<init>"));
            }
            super(module, pointers);
            this.myProviderName = providerName;
        }

        public String toString() {
            return this.myProviderName + ": " + super.toString();
        }
    }
}

